import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EmailSenderVerificationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Email sender ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_sender_verification.html#sender_id EmailSenderVerification#sender_id}
     *
     * @stability stable
     */
    readonly senderId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/email_sender_verification.html okta_email_sender_verification}.
 *
 * @stability stable
 */
export declare class EmailSenderVerification extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/email_sender_verification.html okta_email_sender_verification} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EmailSenderVerificationConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _senderId?;
    /**
     * @stability stable
     */
    get senderId(): string;
    /**
     * @stability stable
     */
    set senderId(value: string);
    /**
     * @stability stable
     */
    get senderIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
