import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EmailSenderConfig extends cdktf.TerraformMetaArguments {
    /**
     * Email address to send from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_sender.html#from_address EmailSender#from_address}
     *
     * @stability stable
     */
    readonly fromAddress: string;
    /**
     * Name of sender.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_sender.html#from_name EmailSender#from_name}
     *
     * @stability stable
     */
    readonly fromName: string;
    /**
     * Mail domain to send from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/email_sender.html#subdomain EmailSender#subdomain}
     *
     * @stability stable
     */
    readonly subdomain: string;
}
/**
 * @stability stable
 */
export declare class EmailSenderDnsRecords extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get recordType(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/email_sender.html okta_email_sender}.
 *
 * @stability stable
 */
export declare class EmailSender extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/email_sender.html okta_email_sender} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EmailSenderConfig);
    /**
     * @stability stable
     */
    dnsRecords(index: string): EmailSenderDnsRecords;
    private _fromAddress?;
    /**
     * @stability stable
     */
    get fromAddress(): string;
    /**
     * @stability stable
     */
    set fromAddress(value: string);
    /**
     * @stability stable
     */
    get fromAddressInput(): string | undefined;
    private _fromName?;
    /**
     * @stability stable
     */
    get fromName(): string;
    /**
     * @stability stable
     */
    set fromName(value: string);
    /**
     * @stability stable
     */
    get fromNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get status(): string;
    private _subdomain?;
    /**
     * @stability stable
     */
    get subdomain(): string;
    /**
     * @stability stable
     */
    set subdomain(value: string);
    /**
     * @stability stable
     */
    get subdomainInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
