import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EventHookVerificationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Event hook ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/event_hook_verification.html#event_hook_id EventHookVerification#event_hook_id}
     *
     * @stability stable
     */
    readonly eventHookId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/event_hook_verification.html okta_event_hook_verification}.
 *
 * @stability stable
 */
export declare class EventHookVerification extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/event_hook_verification.html okta_event_hook_verification} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EventHookVerificationConfig);
    private _eventHookId?;
    /**
     * @stability stable
     */
    get eventHookId(): string;
    /**
     * @stability stable
     */
    set eventHookId(value: string);
    /**
     * @stability stable
     */
    get eventHookIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
