import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EventHookConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/event_hook.html#auth EventHook#auth}.
     *
     * @stability stable
     */
    readonly auth?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/event_hook.html#channel EventHook#channel}.
     *
     * @stability stable
     */
    readonly channel: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/event_hook.html#events EventHook#events}.
     *
     * @stability stable
     */
    readonly events: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/event_hook.html#name EventHook#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/event_hook.html#status EventHook#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * headers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/event_hook.html#headers EventHook#headers}
     *
     * @stability stable
     */
    readonly headers?: EventHookHeaders[];
}
/**
 * @stability stable
 */
export interface EventHookHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/event_hook.html#key EventHook#key}.
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/event_hook.html#value EventHook#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function eventHookHeadersToTerraform(struct?: EventHookHeaders): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/event_hook.html okta_event_hook}.
 *
 * @stability stable
 */
export declare class EventHook extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/event_hook.html okta_event_hook} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EventHookConfig);
    private _auth?;
    /**
     * @stability stable
     */
    get auth(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set auth(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAuth(): void;
    /**
     * @stability stable
     */
    get authInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _channel?;
    /**
     * @stability stable
     */
    get channel(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set channel(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get channelInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _events?;
    /**
     * @stability stable
     */
    get events(): string[];
    /**
     * @stability stable
     */
    set events(value: string[]);
    /**
     * @stability stable
     */
    get eventsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _headers?;
    /**
     * @stability stable
     */
    get headers(): EventHookHeaders[];
    /**
     * @stability stable
     */
    set headers(value: EventHookHeaders[]);
    /**
     * @stability stable
     */
    resetHeaders(): void;
    /**
     * @stability stable
     */
    get headersInput(): EventHookHeaders[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
