import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FactorTotpConfig extends cdktf.TerraformMetaArguments {
    /**
     * Clock drift interval.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor_totp.html#clock_drift_interval FactorTotp#clock_drift_interval}
     *
     * @stability stable
     */
    readonly clockDriftInterval?: number;
    /**
     * Hash-based message authentication code algorithm.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor_totp.html#hmac_algorithm FactorTotp#hmac_algorithm}
     *
     * @stability stable
     */
    readonly hmacAlgorithm?: string;
    /**
     * Factor name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor_totp.html#name FactorTotp#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Factor name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor_totp.html#otp_length FactorTotp#otp_length}
     *
     * @stability stable
     */
    readonly otpLength?: number;
    /**
     * Shared secret encoding.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor_totp.html#shared_secret_encoding FactorTotp#shared_secret_encoding}
     *
     * @stability stable
     */
    readonly sharedSecretEncoding?: string;
    /**
     * Time step in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor_totp.html#time_step FactorTotp#time_step}
     *
     * @stability stable
     */
    readonly timeStep?: number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/factor_totp.html okta_factor_totp}.
 *
 * @stability stable
 */
export declare class FactorTotp extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/factor_totp.html okta_factor_totp} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FactorTotpConfig);
    private _clockDriftInterval?;
    /**
     * @stability stable
     */
    get clockDriftInterval(): number;
    /**
     * @stability stable
     */
    set clockDriftInterval(value: number);
    /**
     * @stability stable
     */
    resetClockDriftInterval(): void;
    /**
     * @stability stable
     */
    get clockDriftIntervalInput(): number | undefined;
    private _hmacAlgorithm?;
    /**
     * @stability stable
     */
    get hmacAlgorithm(): string;
    /**
     * @stability stable
     */
    set hmacAlgorithm(value: string);
    /**
     * @stability stable
     */
    resetHmacAlgorithm(): void;
    /**
     * @stability stable
     */
    get hmacAlgorithmInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _otpLength?;
    /**
     * @stability stable
     */
    get otpLength(): number;
    /**
     * @stability stable
     */
    set otpLength(value: number);
    /**
     * @stability stable
     */
    resetOtpLength(): void;
    /**
     * @stability stable
     */
    get otpLengthInput(): number | undefined;
    private _sharedSecretEncoding?;
    /**
     * @stability stable
     */
    get sharedSecretEncoding(): string;
    /**
     * @stability stable
     */
    set sharedSecretEncoding(value: string);
    /**
     * @stability stable
     */
    resetSharedSecretEncoding(): void;
    /**
     * @stability stable
     */
    get sharedSecretEncodingInput(): string | undefined;
    private _timeStep?;
    /**
     * @stability stable
     */
    get timeStep(): number;
    /**
     * @stability stable
     */
    set timeStep(value: number);
    /**
     * @stability stable
     */
    resetTimeStep(): void;
    /**
     * @stability stable
     */
    get timeStepInput(): number | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
