import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FactorConfig extends cdktf.TerraformMetaArguments {
    /**
     * Is this provider active?
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor.html#active Factor#active}
     *
     * @stability stable
     */
    readonly active?: boolean | cdktf.IResolvable;
    /**
     * Factor provider ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/factor.html#provider_id Factor#provider_id}
     *
     * @stability stable
     */
    readonly providerId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/factor.html okta_factor}.
 *
 * @stability stable
 */
export declare class Factor extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/factor.html okta_factor} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FactorConfig);
    private _active?;
    /**
     * @stability stable
     */
    get active(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set active(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetActive(): void;
    /**
     * @stability stable
     */
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _providerId?;
    /**
     * @stability stable
     */
    get providerId(): string;
    /**
     * @stability stable
     */
    set providerId(value: string);
    /**
     * @stability stable
     */
    get providerIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
