import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GroupMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
     * ID of a Okta Group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_membership.html#group_id GroupMembership#group_id}
     *
     * @stability stable
     */
    readonly groupId: string;
    /**
     * ID of a Okta User.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_membership.html#user_id GroupMembership#user_id}
     *
     * @stability stable
     */
    readonly userId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/group_membership.html okta_group_membership}.
 *
 * @stability stable
 */
export declare class GroupMembership extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/group_membership.html okta_group_membership} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: GroupMembershipConfig);
    private _groupId?;
    /**
     * @stability stable
     */
    get groupId(): string;
    /**
     * @stability stable
     */
    set groupId(value: string);
    /**
     * @stability stable
     */
    get groupIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string;
    /**
     * @stability stable
     */
    set userId(value: string);
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
