import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GroupMembershipsConfig extends cdktf.TerraformMetaArguments {
    /**
     * ID of a Okta group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_memberships.html#group_id GroupMemberships#group_id}
     *
     * @stability stable
     */
    readonly groupId: string;
    /**
     * The list of Okta user IDs which the group should have membership managed for.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_memberships.html#users GroupMemberships#users}
     *
     * @stability stable
     */
    readonly users: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/group_memberships.html okta_group_memberships}.
 *
 * @stability stable
 */
export declare class GroupMemberships extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/group_memberships.html okta_group_memberships} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: GroupMembershipsConfig);
    private _groupId?;
    /**
     * @stability stable
     */
    get groupId(): string;
    /**
     * @stability stable
     */
    set groupId(value: string);
    /**
     * @stability stable
     */
    get groupIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _users?;
    /**
     * @stability stable
     */
    get users(): string[];
    /**
     * @stability stable
     */
    set users(value: string[]);
    /**
     * @stability stable
     */
    get usersInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
