import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GroupRoleConfig extends cdktf.TerraformMetaArguments {
    /**
     * When this setting is enabled, the admins won't receive any of the default Okta administrator emails.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_role.html#disable_notifications GroupRole#disable_notifications}
     *
     * @stability stable
     */
    readonly disableNotifications?: boolean | cdktf.IResolvable;
    /**
     * ID of group to attach admin roles to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_role.html#group_id GroupRole#group_id}
     *
     * @stability stable
     */
    readonly groupId: string;
    /**
     * Type of Role to assign.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_role.html#role_type GroupRole#role_type}
     *
     * @stability stable
     */
    readonly roleType: string;
    /**
     * List of apps ids for the targets of the admin role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_role.html#target_app_list GroupRole#target_app_list}
     *
     * @stability stable
     */
    readonly targetAppList?: string[];
    /**
     * List of groups ids for the targets of the admin role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_role.html#target_group_list GroupRole#target_group_list}
     *
     * @stability stable
     */
    readonly targetGroupList?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/group_role.html okta_group_role}.
 *
 * @stability stable
 */
export declare class GroupRole extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/group_role.html okta_group_role} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: GroupRoleConfig);
    private _disableNotifications?;
    /**
     * @stability stable
     */
    get disableNotifications(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableNotifications(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableNotifications(): void;
    /**
     * @stability stable
     */
    get disableNotificationsInput(): boolean | cdktf.IResolvable | undefined;
    private _groupId?;
    /**
     * @stability stable
     */
    get groupId(): string;
    /**
     * @stability stable
     */
    set groupId(value: string);
    /**
     * @stability stable
     */
    get groupIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _roleType?;
    /**
     * @stability stable
     */
    get roleType(): string;
    /**
     * @stability stable
     */
    set roleType(value: string);
    /**
     * @stability stable
     */
    get roleTypeInput(): string | undefined;
    private _targetAppList?;
    /**
     * @stability stable
     */
    get targetAppList(): string[];
    /**
     * @stability stable
     */
    set targetAppList(value: string[]);
    /**
     * @stability stable
     */
    resetTargetAppList(): void;
    /**
     * @stability stable
     */
    get targetAppListInput(): string[] | undefined;
    private _targetGroupList?;
    /**
     * @stability stable
     */
    get targetGroupList(): string[];
    /**
     * @stability stable
     */
    set targetGroupList(value: string[]);
    /**
     * @stability stable
     */
    resetTargetGroupList(): void;
    /**
     * @stability stable
     */
    get targetGroupListInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
