import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GroupRolesConfig extends cdktf.TerraformMetaArguments {
    /**
     * Admin roles associated with the group. This can also be done per user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_roles.html#admin_roles GroupRoles#admin_roles}
     *
     * @stability stable
     */
    readonly adminRoles?: string[];
    /**
     * ID of group to attach admin roles to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_roles.html#group_id GroupRoles#group_id}
     *
     * @stability stable
     */
    readonly groupId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/group_roles.html okta_group_roles}.
 *
 * @stability stable
 */
export declare class GroupRoles extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/group_roles.html okta_group_roles} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: GroupRolesConfig);
    private _adminRoles?;
    /**
     * @stability stable
     */
    get adminRoles(): string[];
    /**
     * @stability stable
     */
    set adminRoles(value: string[]);
    /**
     * @stability stable
     */
    resetAdminRoles(): void;
    /**
     * @stability stable
     */
    get adminRolesInput(): string[] | undefined;
    private _groupId?;
    /**
     * @stability stable
     */
    get groupId(): string;
    /**
     * @stability stable
     */
    set groupId(value: string);
    /**
     * @stability stable
     */
    get groupIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
