import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GroupRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_rule.html#expression_type GroupRule#expression_type}.
     *
     * @stability stable
     */
    readonly expressionType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_rule.html#expression_value GroupRule#expression_value}.
     *
     * @stability stable
     */
    readonly expressionValue: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_rule.html#group_assignments GroupRule#group_assignments}.
     *
     * @stability stable
     */
    readonly groupAssignments: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_rule.html#name GroupRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Remove users added by this rule from the assigned group after deleting this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_rule.html#remove_assigned_users GroupRule#remove_assigned_users}
     *
     * @stability stable
     */
    readonly removeAssignedUsers?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_rule.html#status GroupRule#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * The list of user IDs that would be excluded when rules are processed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_rule.html#users_excluded GroupRule#users_excluded}
     *
     * @stability stable
     */
    readonly usersExcluded?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/group_rule.html okta_group_rule}.
 *
 * @stability stable
 */
export declare class GroupRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/group_rule.html okta_group_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: GroupRuleConfig);
    private _expressionType?;
    /**
     * @stability stable
     */
    get expressionType(): string;
    /**
     * @stability stable
     */
    set expressionType(value: string);
    /**
     * @stability stable
     */
    resetExpressionType(): void;
    /**
     * @stability stable
     */
    get expressionTypeInput(): string | undefined;
    private _expressionValue?;
    /**
     * @stability stable
     */
    get expressionValue(): string;
    /**
     * @stability stable
     */
    set expressionValue(value: string);
    /**
     * @stability stable
     */
    get expressionValueInput(): string | undefined;
    private _groupAssignments?;
    /**
     * @stability stable
     */
    get groupAssignments(): string[];
    /**
     * @stability stable
     */
    set groupAssignments(value: string[]);
    /**
     * @stability stable
     */
    get groupAssignmentsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _removeAssignedUsers?;
    /**
     * @stability stable
     */
    get removeAssignedUsers(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set removeAssignedUsers(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRemoveAssignedUsers(): void;
    /**
     * @stability stable
     */
    get removeAssignedUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _usersExcluded?;
    /**
     * @stability stable
     */
    get usersExcluded(): string[];
    /**
     * @stability stable
     */
    set usersExcluded(value: string[]);
    /**
     * @stability stable
     */
    resetUsersExcluded(): void;
    /**
     * @stability stable
     */
    get usersExcludedInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
