import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GroupSchemaPropertyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Custom Subschema enumerated value of a property of type array.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#array_enum GroupSchemaProperty#array_enum}
     *
     * @stability stable
     */
    readonly arrayEnum?: string[];
    /**
     * Subschema array type: string, number, integer, reference. Type field must be an array.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#array_type GroupSchemaProperty#array_type}
     *
     * @stability stable
     */
    readonly arrayType?: string;
    /**
     * Custom Subschema description.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#description GroupSchemaProperty#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Custom Subschema enumerated value of the property. see: developer.okta.com/docs/api/resources/schemas#user-profile-schema-property-object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#enum GroupSchemaProperty#enum}
     *
     * @stability stable
     */
    readonly enum?: string[];
    /**
     * Subschema external name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#external_name GroupSchemaProperty#external_name}
     *
     * @stability stable
     */
    readonly externalName?: string;
    /**
     * Subschema external namespace.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#external_namespace GroupSchemaProperty#external_namespace}
     *
     * @stability stable
     */
    readonly externalNamespace?: string;
    /**
     * Subschema unique string identifier.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#index GroupSchemaProperty#index}
     *
     * @stability stable
     */
    readonly index: string;
    /**
     * SubSchema profile manager, if not set it will inherit its setting.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#master GroupSchemaProperty#master}
     *
     * @stability stable
     */
    readonly master?: string;
    /**
     * Subschema of type string maximum length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#max_length GroupSchemaProperty#max_length}
     *
     * @stability stable
     */
    readonly maxLength?: number;
    /**
     * Subschema of type string minimum length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#min_length GroupSchemaProperty#min_length}
     *
     * @stability stable
     */
    readonly minLength?: number;
    /**
     * SubSchema permissions: HIDE, READ_ONLY, or READ_WRITE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#permissions GroupSchemaProperty#permissions}
     *
     * @stability stable
     */
    readonly permissions?: string;
    /**
     * Whether the subschema is required.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#required GroupSchemaProperty#required}
     *
     * @stability stable
     */
    readonly required?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#scope GroupSchemaProperty#scope}.
     *
     * @stability stable
     */
    readonly scope?: string;
    /**
     * Subschema title (display name).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#title GroupSchemaProperty#title}
     *
     * @stability stable
     */
    readonly title: string;
    /**
     * Subschema type: string, boolean, number, integer, array, or object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#type GroupSchemaProperty#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Subschema unique restriction.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#unique GroupSchemaProperty#unique}
     *
     * @stability stable
     */
    readonly unique?: string;
    /**
     * array_one_of block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#array_one_of GroupSchemaProperty#array_one_of}
     *
     * @stability stable
     */
    readonly arrayOneOf?: GroupSchemaPropertyArrayOneOf[];
    /**
     * master_override_priority block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#master_override_priority GroupSchemaProperty#master_override_priority}
     *
     * @stability stable
     */
    readonly masterOverridePriority?: GroupSchemaPropertyMasterOverridePriority[];
    /**
     * one_of block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#one_of GroupSchemaProperty#one_of}
     *
     * @stability stable
     */
    readonly oneOf?: GroupSchemaPropertyOneOf[];
}
/**
 * @stability stable
 */
export interface GroupSchemaPropertyArrayOneOf {
    /**
     * Enum value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#const GroupSchemaProperty#const}
     *
     * @stability stable
     */
    readonly const: string;
    /**
     * Enum title.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#title GroupSchemaProperty#title}
     *
     * @stability stable
     */
    readonly title: string;
}
export declare function groupSchemaPropertyArrayOneOfToTerraform(struct?: GroupSchemaPropertyArrayOneOf): any;
/**
 * @stability stable
 */
export interface GroupSchemaPropertyMasterOverridePriority {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#type GroupSchemaProperty#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#value GroupSchemaProperty#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function groupSchemaPropertyMasterOverridePriorityToTerraform(struct?: GroupSchemaPropertyMasterOverridePriority): any;
/**
 * @stability stable
 */
export interface GroupSchemaPropertyOneOf {
    /**
     * Enum value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#const GroupSchemaProperty#const}
     *
     * @stability stable
     */
    readonly const: string;
    /**
     * Enum title.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html#title GroupSchemaProperty#title}
     *
     * @stability stable
     */
    readonly title: string;
}
export declare function groupSchemaPropertyOneOfToTerraform(struct?: GroupSchemaPropertyOneOf): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html okta_group_schema_property}.
 *
 * @stability stable
 */
export declare class GroupSchemaProperty extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/group_schema_property.html okta_group_schema_property} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: GroupSchemaPropertyConfig);
    private _arrayEnum?;
    /**
     * @stability stable
     */
    get arrayEnum(): string[];
    /**
     * @stability stable
     */
    set arrayEnum(value: string[]);
    /**
     * @stability stable
     */
    resetArrayEnum(): void;
    /**
     * @stability stable
     */
    get arrayEnumInput(): string[] | undefined;
    private _arrayType?;
    /**
     * @stability stable
     */
    get arrayType(): string;
    /**
     * @stability stable
     */
    set arrayType(value: string);
    /**
     * @stability stable
     */
    resetArrayType(): void;
    /**
     * @stability stable
     */
    get arrayTypeInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enum?;
    /**
     * @stability stable
     */
    get enum(): string[];
    /**
     * @stability stable
     */
    set enum(value: string[]);
    /**
     * @stability stable
     */
    resetEnum(): void;
    /**
     * @stability stable
     */
    get enumInput(): string[] | undefined;
    private _externalName?;
    /**
     * @stability stable
     */
    get externalName(): string;
    /**
     * @stability stable
     */
    set externalName(value: string);
    /**
     * @stability stable
     */
    resetExternalName(): void;
    /**
     * @stability stable
     */
    get externalNameInput(): string | undefined;
    private _externalNamespace?;
    /**
     * @stability stable
     */
    get externalNamespace(): string;
    /**
     * @stability stable
     */
    set externalNamespace(value: string);
    /**
     * @stability stable
     */
    resetExternalNamespace(): void;
    /**
     * @stability stable
     */
    get externalNamespaceInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _index?;
    /**
     * @stability stable
     */
    get index(): string;
    /**
     * @stability stable
     */
    set index(value: string);
    /**
     * @stability stable
     */
    get indexInput(): string | undefined;
    private _master?;
    /**
     * @stability stable
     */
    get master(): string;
    /**
     * @stability stable
     */
    set master(value: string);
    /**
     * @stability stable
     */
    resetMaster(): void;
    /**
     * @stability stable
     */
    get masterInput(): string | undefined;
    private _maxLength?;
    /**
     * @stability stable
     */
    get maxLength(): number;
    /**
     * @stability stable
     */
    set maxLength(value: number);
    /**
     * @stability stable
     */
    resetMaxLength(): void;
    /**
     * @stability stable
     */
    get maxLengthInput(): number | undefined;
    private _minLength?;
    /**
     * @stability stable
     */
    get minLength(): number;
    /**
     * @stability stable
     */
    set minLength(value: number);
    /**
     * @stability stable
     */
    resetMinLength(): void;
    /**
     * @stability stable
     */
    get minLengthInput(): number | undefined;
    private _permissions?;
    /**
     * @stability stable
     */
    get permissions(): string;
    /**
     * @stability stable
     */
    set permissions(value: string);
    /**
     * @stability stable
     */
    resetPermissions(): void;
    /**
     * @stability stable
     */
    get permissionsInput(): string | undefined;
    private _required?;
    /**
     * @stability stable
     */
    get required(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set required(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequired(): void;
    /**
     * @stability stable
     */
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    set scope(value: string);
    /**
     * @stability stable
     */
    resetScope(): void;
    /**
     * @stability stable
     */
    get scopeInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _unique?;
    /**
     * @stability stable
     */
    get unique(): string;
    /**
     * @stability stable
     */
    set unique(value: string);
    /**
     * @stability stable
     */
    resetUnique(): void;
    /**
     * @stability stable
     */
    get uniqueInput(): string | undefined;
    private _arrayOneOf?;
    /**
     * @stability stable
     */
    get arrayOneOf(): GroupSchemaPropertyArrayOneOf[];
    /**
     * @stability stable
     */
    set arrayOneOf(value: GroupSchemaPropertyArrayOneOf[]);
    /**
     * @stability stable
     */
    resetArrayOneOf(): void;
    /**
     * @stability stable
     */
    get arrayOneOfInput(): GroupSchemaPropertyArrayOneOf[] | undefined;
    private _masterOverridePriority?;
    /**
     * @stability stable
     */
    get masterOverridePriority(): GroupSchemaPropertyMasterOverridePriority[];
    /**
     * @stability stable
     */
    set masterOverridePriority(value: GroupSchemaPropertyMasterOverridePriority[]);
    /**
     * @stability stable
     */
    resetMasterOverridePriority(): void;
    /**
     * @stability stable
     */
    get masterOverridePriorityInput(): GroupSchemaPropertyMasterOverridePriority[] | undefined;
    private _oneOf?;
    /**
     * @stability stable
     */
    get oneOf(): GroupSchemaPropertyOneOf[];
    /**
     * @stability stable
     */
    set oneOf(value: GroupSchemaPropertyOneOf[]);
    /**
     * @stability stable
     */
    resetOneOf(): void;
    /**
     * @stability stable
     */
    get oneOfInput(): GroupSchemaPropertyOneOf[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
