import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Group description.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group.html#description Group#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Group name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group.html#name Group#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Ignore users sync. This is a temporary solution until 'users' field is supported in this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group.html#skip_users Group#skip_users}
     *
     * @stability stable
     */
    readonly skipUsers?: boolean | cdktf.IResolvable;
    /**
     * Users associated with the group. This can also be done per user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/group.html#users Group#users}
     *
     * @stability stable
     */
    readonly users?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/group.html okta_group}.
 *
 * @stability stable
 */
export declare class Group extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/group.html okta_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: GroupConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _skipUsers?;
    /**
     * @stability stable
     */
    get skipUsers(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipUsers(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipUsers(): void;
    /**
     * @stability stable
     */
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _users?;
    /**
     * @stability stable
     */
    get users(): string[];
    /**
     * @stability stable
     */
    set users(value: string[]);
    /**
     * @stability stable
     */
    resetUsers(): void;
    /**
     * @stability stable
     */
    get usersInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
