import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdpOidcConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#account_link_action IdpOidc#account_link_action}.
     *
     * @stability stable
     */
    readonly accountLinkAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#account_link_group_include IdpOidc#account_link_group_include}.
     *
     * @stability stable
     */
    readonly accountLinkGroupInclude?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#authorization_binding IdpOidc#authorization_binding}.
     *
     * @stability stable
     */
    readonly authorizationBinding: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#authorization_url IdpOidc#authorization_url}.
     *
     * @stability stable
     */
    readonly authorizationUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#client_id IdpOidc#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#client_secret IdpOidc#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#deprovisioned_action IdpOidc#deprovisioned_action}.
     *
     * @stability stable
     */
    readonly deprovisionedAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#groups_action IdpOidc#groups_action}.
     *
     * @stability stable
     */
    readonly groupsAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#groups_assignment IdpOidc#groups_assignment}.
     *
     * @stability stable
     */
    readonly groupsAssignment?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#groups_attribute IdpOidc#groups_attribute}.
     *
     * @stability stable
     */
    readonly groupsAttribute?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#groups_filter IdpOidc#groups_filter}.
     *
     * @stability stable
     */
    readonly groupsFilter?: string[];
    /**
     * Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#issuer_mode IdpOidc#issuer_mode}
     *
     * @stability stable
     */
    readonly issuerMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#issuer_url IdpOidc#issuer_url}.
     *
     * @stability stable
     */
    readonly issuerUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#jwks_binding IdpOidc#jwks_binding}.
     *
     * @stability stable
     */
    readonly jwksBinding: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#jwks_url IdpOidc#jwks_url}.
     *
     * @stability stable
     */
    readonly jwksUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#max_clock_skew IdpOidc#max_clock_skew}.
     *
     * @stability stable
     */
    readonly maxClockSkew?: number;
    /**
     * Name of the IdP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#name IdpOidc#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#profile_master IdpOidc#profile_master}.
     *
     * @stability stable
     */
    readonly profileMaster?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#protocol_type IdpOidc#protocol_type}.
     *
     * @stability stable
     */
    readonly protocolType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#provisioning_action IdpOidc#provisioning_action}.
     *
     * @stability stable
     */
    readonly provisioningAction?: string;
    /**
     * algorithm to use to sign requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#request_signature_algorithm IdpOidc#request_signature_algorithm}
     *
     * @stability stable
     */
    readonly requestSignatureAlgorithm?: string;
    /**
     * algorithm to use to sign response.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#request_signature_scope IdpOidc#request_signature_scope}
     *
     * @stability stable
     */
    readonly requestSignatureScope?: string;
    /**
     * algorithm to use to sign requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#response_signature_algorithm IdpOidc#response_signature_algorithm}
     *
     * @stability stable
     */
    readonly responseSignatureAlgorithm?: string;
    /**
     * algorithm to use to sign response.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#response_signature_scope IdpOidc#response_signature_scope}
     *
     * @stability stable
     */
    readonly responseSignatureScope?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#scopes IdpOidc#scopes}.
     *
     * @stability stable
     */
    readonly scopes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#status IdpOidc#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#subject_match_attribute IdpOidc#subject_match_attribute}.
     *
     * @stability stable
     */
    readonly subjectMatchAttribute?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#subject_match_type IdpOidc#subject_match_type}.
     *
     * @stability stable
     */
    readonly subjectMatchType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#suspended_action IdpOidc#suspended_action}.
     *
     * @stability stable
     */
    readonly suspendedAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#token_binding IdpOidc#token_binding}.
     *
     * @stability stable
     */
    readonly tokenBinding: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#token_url IdpOidc#token_url}.
     *
     * @stability stable
     */
    readonly tokenUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#user_info_binding IdpOidc#user_info_binding}.
     *
     * @stability stable
     */
    readonly userInfoBinding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#user_info_url IdpOidc#user_info_url}.
     *
     * @stability stable
     */
    readonly userInfoUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html#username_template IdpOidc#username_template}.
     *
     * @stability stable
     */
    readonly usernameTemplate?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html okta_idp_oidc}.
 *
 * @stability stable
 */
export declare class IdpOidc extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/idp_oidc.html okta_idp_oidc} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IdpOidcConfig);
    private _accountLinkAction?;
    /**
     * @stability stable
     */
    get accountLinkAction(): string;
    /**
     * @stability stable
     */
    set accountLinkAction(value: string);
    /**
     * @stability stable
     */
    resetAccountLinkAction(): void;
    /**
     * @stability stable
     */
    get accountLinkActionInput(): string | undefined;
    private _accountLinkGroupInclude?;
    /**
     * @stability stable
     */
    get accountLinkGroupInclude(): string[];
    /**
     * @stability stable
     */
    set accountLinkGroupInclude(value: string[]);
    /**
     * @stability stable
     */
    resetAccountLinkGroupInclude(): void;
    /**
     * @stability stable
     */
    get accountLinkGroupIncludeInput(): string[] | undefined;
    private _authorizationBinding?;
    /**
     * @stability stable
     */
    get authorizationBinding(): string;
    /**
     * @stability stable
     */
    set authorizationBinding(value: string);
    /**
     * @stability stable
     */
    get authorizationBindingInput(): string | undefined;
    private _authorizationUrl?;
    /**
     * @stability stable
     */
    get authorizationUrl(): string;
    /**
     * @stability stable
     */
    set authorizationUrl(value: string);
    /**
     * @stability stable
     */
    get authorizationUrlInput(): string | undefined;
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _deprovisionedAction?;
    /**
     * @stability stable
     */
    get deprovisionedAction(): string;
    /**
     * @stability stable
     */
    set deprovisionedAction(value: string);
    /**
     * @stability stable
     */
    resetDeprovisionedAction(): void;
    /**
     * @stability stable
     */
    get deprovisionedActionInput(): string | undefined;
    private _groupsAction?;
    /**
     * @stability stable
     */
    get groupsAction(): string;
    /**
     * @stability stable
     */
    set groupsAction(value: string);
    /**
     * @stability stable
     */
    resetGroupsAction(): void;
    /**
     * @stability stable
     */
    get groupsActionInput(): string | undefined;
    private _groupsAssignment?;
    /**
     * @stability stable
     */
    get groupsAssignment(): string[];
    /**
     * @stability stable
     */
    set groupsAssignment(value: string[]);
    /**
     * @stability stable
     */
    resetGroupsAssignment(): void;
    /**
     * @stability stable
     */
    get groupsAssignmentInput(): string[] | undefined;
    private _groupsAttribute?;
    /**
     * @stability stable
     */
    get groupsAttribute(): string;
    /**
     * @stability stable
     */
    set groupsAttribute(value: string);
    /**
     * @stability stable
     */
    resetGroupsAttribute(): void;
    /**
     * @stability stable
     */
    get groupsAttributeInput(): string | undefined;
    private _groupsFilter?;
    /**
     * @stability stable
     */
    get groupsFilter(): string[];
    /**
     * @stability stable
     */
    set groupsFilter(value: string[]);
    /**
     * @stability stable
     */
    resetGroupsFilter(): void;
    /**
     * @stability stable
     */
    get groupsFilterInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _issuerMode?;
    /**
     * @stability stable
     */
    get issuerMode(): string;
    /**
     * @stability stable
     */
    set issuerMode(value: string);
    /**
     * @stability stable
     */
    resetIssuerMode(): void;
    /**
     * @stability stable
     */
    get issuerModeInput(): string | undefined;
    private _issuerUrl?;
    /**
     * @stability stable
     */
    get issuerUrl(): string;
    /**
     * @stability stable
     */
    set issuerUrl(value: string);
    /**
     * @stability stable
     */
    get issuerUrlInput(): string | undefined;
    private _jwksBinding?;
    /**
     * @stability stable
     */
    get jwksBinding(): string;
    /**
     * @stability stable
     */
    set jwksBinding(value: string);
    /**
     * @stability stable
     */
    get jwksBindingInput(): string | undefined;
    private _jwksUrl?;
    /**
     * @stability stable
     */
    get jwksUrl(): string;
    /**
     * @stability stable
     */
    set jwksUrl(value: string);
    /**
     * @stability stable
     */
    get jwksUrlInput(): string | undefined;
    private _maxClockSkew?;
    /**
     * @stability stable
     */
    get maxClockSkew(): number;
    /**
     * @stability stable
     */
    set maxClockSkew(value: number);
    /**
     * @stability stable
     */
    resetMaxClockSkew(): void;
    /**
     * @stability stable
     */
    get maxClockSkewInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _profileMaster?;
    /**
     * @stability stable
     */
    get profileMaster(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set profileMaster(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProfileMaster(): void;
    /**
     * @stability stable
     */
    get profileMasterInput(): boolean | cdktf.IResolvable | undefined;
    private _protocolType?;
    /**
     * @stability stable
     */
    get protocolType(): string;
    /**
     * @stability stable
     */
    set protocolType(value: string);
    /**
     * @stability stable
     */
    resetProtocolType(): void;
    /**
     * @stability stable
     */
    get protocolTypeInput(): string | undefined;
    private _provisioningAction?;
    /**
     * @stability stable
     */
    get provisioningAction(): string;
    /**
     * @stability stable
     */
    set provisioningAction(value: string);
    /**
     * @stability stable
     */
    resetProvisioningAction(): void;
    /**
     * @stability stable
     */
    get provisioningActionInput(): string | undefined;
    private _requestSignatureAlgorithm?;
    /**
     * @stability stable
     */
    get requestSignatureAlgorithm(): string;
    /**
     * @stability stable
     */
    set requestSignatureAlgorithm(value: string);
    /**
     * @stability stable
     */
    resetRequestSignatureAlgorithm(): void;
    /**
     * @stability stable
     */
    get requestSignatureAlgorithmInput(): string | undefined;
    private _requestSignatureScope?;
    /**
     * @stability stable
     */
    get requestSignatureScope(): string;
    /**
     * @stability stable
     */
    set requestSignatureScope(value: string);
    /**
     * @stability stable
     */
    resetRequestSignatureScope(): void;
    /**
     * @stability stable
     */
    get requestSignatureScopeInput(): string | undefined;
    private _responseSignatureAlgorithm?;
    /**
     * @stability stable
     */
    get responseSignatureAlgorithm(): string;
    /**
     * @stability stable
     */
    set responseSignatureAlgorithm(value: string);
    /**
     * @stability stable
     */
    resetResponseSignatureAlgorithm(): void;
    /**
     * @stability stable
     */
    get responseSignatureAlgorithmInput(): string | undefined;
    private _responseSignatureScope?;
    /**
     * @stability stable
     */
    get responseSignatureScope(): string;
    /**
     * @stability stable
     */
    set responseSignatureScope(value: string);
    /**
     * @stability stable
     */
    resetResponseSignatureScope(): void;
    /**
     * @stability stable
     */
    get responseSignatureScopeInput(): string | undefined;
    private _scopes?;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    set scopes(value: string[]);
    /**
     * @stability stable
     */
    get scopesInput(): string[] | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _subjectMatchAttribute?;
    /**
     * @stability stable
     */
    get subjectMatchAttribute(): string;
    /**
     * @stability stable
     */
    set subjectMatchAttribute(value: string);
    /**
     * @stability stable
     */
    resetSubjectMatchAttribute(): void;
    /**
     * @stability stable
     */
    get subjectMatchAttributeInput(): string | undefined;
    private _subjectMatchType?;
    /**
     * @stability stable
     */
    get subjectMatchType(): string;
    /**
     * @stability stable
     */
    set subjectMatchType(value: string);
    /**
     * @stability stable
     */
    resetSubjectMatchType(): void;
    /**
     * @stability stable
     */
    get subjectMatchTypeInput(): string | undefined;
    private _suspendedAction?;
    /**
     * @stability stable
     */
    get suspendedAction(): string;
    /**
     * @stability stable
     */
    set suspendedAction(value: string);
    /**
     * @stability stable
     */
    resetSuspendedAction(): void;
    /**
     * @stability stable
     */
    get suspendedActionInput(): string | undefined;
    private _tokenBinding?;
    /**
     * @stability stable
     */
    get tokenBinding(): string;
    /**
     * @stability stable
     */
    set tokenBinding(value: string);
    /**
     * @stability stable
     */
    get tokenBindingInput(): string | undefined;
    private _tokenUrl?;
    /**
     * @stability stable
     */
    get tokenUrl(): string;
    /**
     * @stability stable
     */
    set tokenUrl(value: string);
    /**
     * @stability stable
     */
    get tokenUrlInput(): string | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    private _userInfoBinding?;
    /**
     * @stability stable
     */
    get userInfoBinding(): string;
    /**
     * @stability stable
     */
    set userInfoBinding(value: string);
    /**
     * @stability stable
     */
    resetUserInfoBinding(): void;
    /**
     * @stability stable
     */
    get userInfoBindingInput(): string | undefined;
    private _userInfoUrl?;
    /**
     * @stability stable
     */
    get userInfoUrl(): string;
    /**
     * @stability stable
     */
    set userInfoUrl(value: string);
    /**
     * @stability stable
     */
    resetUserInfoUrl(): void;
    /**
     * @stability stable
     */
    get userInfoUrlInput(): string | undefined;
    private _usernameTemplate?;
    /**
     * @stability stable
     */
    get usernameTemplate(): string;
    /**
     * @stability stable
     */
    set usernameTemplate(value: string);
    /**
     * @stability stable
     */
    resetUsernameTemplate(): void;
    /**
     * @stability stable
     */
    get usernameTemplateInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
