import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdpConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#account_link_action Idp#account_link_action}.
     *
     * @stability stable
     */
    readonly accountLinkAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#account_link_group_include Idp#account_link_group_include}.
     *
     * @stability stable
     */
    readonly accountLinkGroupInclude?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#authorization_binding Idp#authorization_binding}.
     *
     * @stability stable
     */
    readonly authorizationBinding: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#authorization_url Idp#authorization_url}.
     *
     * @stability stable
     */
    readonly authorizationUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#client_id Idp#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#client_secret Idp#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#deprovisioned_action Idp#deprovisioned_action}.
     *
     * @stability stable
     */
    readonly deprovisionedAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#groups_action Idp#groups_action}.
     *
     * @stability stable
     */
    readonly groupsAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#groups_assignment Idp#groups_assignment}.
     *
     * @stability stable
     */
    readonly groupsAssignment?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#groups_attribute Idp#groups_attribute}.
     *
     * @stability stable
     */
    readonly groupsAttribute?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#groups_filter Idp#groups_filter}.
     *
     * @stability stable
     */
    readonly groupsFilter?: string[];
    /**
     * Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#issuer_mode Idp#issuer_mode}
     *
     * @stability stable
     */
    readonly issuerMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#issuer_url Idp#issuer_url}.
     *
     * @stability stable
     */
    readonly issuerUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#jwks_binding Idp#jwks_binding}.
     *
     * @stability stable
     */
    readonly jwksBinding: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#jwks_url Idp#jwks_url}.
     *
     * @stability stable
     */
    readonly jwksUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#max_clock_skew Idp#max_clock_skew}.
     *
     * @stability stable
     */
    readonly maxClockSkew?: number;
    /**
     * Name of the IdP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#name Idp#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#profile_master Idp#profile_master}.
     *
     * @stability stable
     */
    readonly profileMaster?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#protocol_type Idp#protocol_type}.
     *
     * @stability stable
     */
    readonly protocolType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#provisioning_action Idp#provisioning_action}.
     *
     * @stability stable
     */
    readonly provisioningAction?: string;
    /**
     * algorithm to use to sign requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#request_signature_algorithm Idp#request_signature_algorithm}
     *
     * @stability stable
     */
    readonly requestSignatureAlgorithm?: string;
    /**
     * algorithm to use to sign response.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#request_signature_scope Idp#request_signature_scope}
     *
     * @stability stable
     */
    readonly requestSignatureScope?: string;
    /**
     * algorithm to use to sign requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#response_signature_algorithm Idp#response_signature_algorithm}
     *
     * @stability stable
     */
    readonly responseSignatureAlgorithm?: string;
    /**
     * algorithm to use to sign response.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#response_signature_scope Idp#response_signature_scope}
     *
     * @stability stable
     */
    readonly responseSignatureScope?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#scopes Idp#scopes}.
     *
     * @stability stable
     */
    readonly scopes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#status Idp#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#subject_match_attribute Idp#subject_match_attribute}.
     *
     * @stability stable
     */
    readonly subjectMatchAttribute?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#subject_match_type Idp#subject_match_type}.
     *
     * @stability stable
     */
    readonly subjectMatchType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#suspended_action Idp#suspended_action}.
     *
     * @stability stable
     */
    readonly suspendedAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#token_binding Idp#token_binding}.
     *
     * @stability stable
     */
    readonly tokenBinding: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#token_url Idp#token_url}.
     *
     * @stability stable
     */
    readonly tokenUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#user_info_binding Idp#user_info_binding}.
     *
     * @stability stable
     */
    readonly userInfoBinding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#user_info_url Idp#user_info_url}.
     *
     * @stability stable
     */
    readonly userInfoUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/idp.html#username_template Idp#username_template}.
     *
     * @stability stable
     */
    readonly usernameTemplate?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/idp.html okta_idp}.
 *
 * @stability stable
 */
export declare class Idp extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/idp.html okta_idp} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IdpConfig);
    private _accountLinkAction?;
    /**
     * @stability stable
     */
    get accountLinkAction(): string;
    /**
     * @stability stable
     */
    set accountLinkAction(value: string);
    /**
     * @stability stable
     */
    resetAccountLinkAction(): void;
    /**
     * @stability stable
     */
    get accountLinkActionInput(): string | undefined;
    private _accountLinkGroupInclude?;
    /**
     * @stability stable
     */
    get accountLinkGroupInclude(): string[];
    /**
     * @stability stable
     */
    set accountLinkGroupInclude(value: string[]);
    /**
     * @stability stable
     */
    resetAccountLinkGroupInclude(): void;
    /**
     * @stability stable
     */
    get accountLinkGroupIncludeInput(): string[] | undefined;
    private _authorizationBinding?;
    /**
     * @stability stable
     */
    get authorizationBinding(): string;
    /**
     * @stability stable
     */
    set authorizationBinding(value: string);
    /**
     * @stability stable
     */
    get authorizationBindingInput(): string | undefined;
    private _authorizationUrl?;
    /**
     * @stability stable
     */
    get authorizationUrl(): string;
    /**
     * @stability stable
     */
    set authorizationUrl(value: string);
    /**
     * @stability stable
     */
    get authorizationUrlInput(): string | undefined;
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _deprovisionedAction?;
    /**
     * @stability stable
     */
    get deprovisionedAction(): string;
    /**
     * @stability stable
     */
    set deprovisionedAction(value: string);
    /**
     * @stability stable
     */
    resetDeprovisionedAction(): void;
    /**
     * @stability stable
     */
    get deprovisionedActionInput(): string | undefined;
    private _groupsAction?;
    /**
     * @stability stable
     */
    get groupsAction(): string;
    /**
     * @stability stable
     */
    set groupsAction(value: string);
    /**
     * @stability stable
     */
    resetGroupsAction(): void;
    /**
     * @stability stable
     */
    get groupsActionInput(): string | undefined;
    private _groupsAssignment?;
    /**
     * @stability stable
     */
    get groupsAssignment(): string[];
    /**
     * @stability stable
     */
    set groupsAssignment(value: string[]);
    /**
     * @stability stable
     */
    resetGroupsAssignment(): void;
    /**
     * @stability stable
     */
    get groupsAssignmentInput(): string[] | undefined;
    private _groupsAttribute?;
    /**
     * @stability stable
     */
    get groupsAttribute(): string;
    /**
     * @stability stable
     */
    set groupsAttribute(value: string);
    /**
     * @stability stable
     */
    resetGroupsAttribute(): void;
    /**
     * @stability stable
     */
    get groupsAttributeInput(): string | undefined;
    private _groupsFilter?;
    /**
     * @stability stable
     */
    get groupsFilter(): string[];
    /**
     * @stability stable
     */
    set groupsFilter(value: string[]);
    /**
     * @stability stable
     */
    resetGroupsFilter(): void;
    /**
     * @stability stable
     */
    get groupsFilterInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _issuerMode?;
    /**
     * @stability stable
     */
    get issuerMode(): string;
    /**
     * @stability stable
     */
    set issuerMode(value: string);
    /**
     * @stability stable
     */
    resetIssuerMode(): void;
    /**
     * @stability stable
     */
    get issuerModeInput(): string | undefined;
    private _issuerUrl?;
    /**
     * @stability stable
     */
    get issuerUrl(): string;
    /**
     * @stability stable
     */
    set issuerUrl(value: string);
    /**
     * @stability stable
     */
    get issuerUrlInput(): string | undefined;
    private _jwksBinding?;
    /**
     * @stability stable
     */
    get jwksBinding(): string;
    /**
     * @stability stable
     */
    set jwksBinding(value: string);
    /**
     * @stability stable
     */
    get jwksBindingInput(): string | undefined;
    private _jwksUrl?;
    /**
     * @stability stable
     */
    get jwksUrl(): string;
    /**
     * @stability stable
     */
    set jwksUrl(value: string);
    /**
     * @stability stable
     */
    get jwksUrlInput(): string | undefined;
    private _maxClockSkew?;
    /**
     * @stability stable
     */
    get maxClockSkew(): number;
    /**
     * @stability stable
     */
    set maxClockSkew(value: number);
    /**
     * @stability stable
     */
    resetMaxClockSkew(): void;
    /**
     * @stability stable
     */
    get maxClockSkewInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _profileMaster?;
    /**
     * @stability stable
     */
    get profileMaster(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set profileMaster(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProfileMaster(): void;
    /**
     * @stability stable
     */
    get profileMasterInput(): boolean | cdktf.IResolvable | undefined;
    private _protocolType?;
    /**
     * @stability stable
     */
    get protocolType(): string;
    /**
     * @stability stable
     */
    set protocolType(value: string);
    /**
     * @stability stable
     */
    resetProtocolType(): void;
    /**
     * @stability stable
     */
    get protocolTypeInput(): string | undefined;
    private _provisioningAction?;
    /**
     * @stability stable
     */
    get provisioningAction(): string;
    /**
     * @stability stable
     */
    set provisioningAction(value: string);
    /**
     * @stability stable
     */
    resetProvisioningAction(): void;
    /**
     * @stability stable
     */
    get provisioningActionInput(): string | undefined;
    private _requestSignatureAlgorithm?;
    /**
     * @stability stable
     */
    get requestSignatureAlgorithm(): string;
    /**
     * @stability stable
     */
    set requestSignatureAlgorithm(value: string);
    /**
     * @stability stable
     */
    resetRequestSignatureAlgorithm(): void;
    /**
     * @stability stable
     */
    get requestSignatureAlgorithmInput(): string | undefined;
    private _requestSignatureScope?;
    /**
     * @stability stable
     */
    get requestSignatureScope(): string;
    /**
     * @stability stable
     */
    set requestSignatureScope(value: string);
    /**
     * @stability stable
     */
    resetRequestSignatureScope(): void;
    /**
     * @stability stable
     */
    get requestSignatureScopeInput(): string | undefined;
    private _responseSignatureAlgorithm?;
    /**
     * @stability stable
     */
    get responseSignatureAlgorithm(): string;
    /**
     * @stability stable
     */
    set responseSignatureAlgorithm(value: string);
    /**
     * @stability stable
     */
    resetResponseSignatureAlgorithm(): void;
    /**
     * @stability stable
     */
    get responseSignatureAlgorithmInput(): string | undefined;
    private _responseSignatureScope?;
    /**
     * @stability stable
     */
    get responseSignatureScope(): string;
    /**
     * @stability stable
     */
    set responseSignatureScope(value: string);
    /**
     * @stability stable
     */
    resetResponseSignatureScope(): void;
    /**
     * @stability stable
     */
    get responseSignatureScopeInput(): string | undefined;
    private _scopes?;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    set scopes(value: string[]);
    /**
     * @stability stable
     */
    get scopesInput(): string[] | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _subjectMatchAttribute?;
    /**
     * @stability stable
     */
    get subjectMatchAttribute(): string;
    /**
     * @stability stable
     */
    set subjectMatchAttribute(value: string);
    /**
     * @stability stable
     */
    resetSubjectMatchAttribute(): void;
    /**
     * @stability stable
     */
    get subjectMatchAttributeInput(): string | undefined;
    private _subjectMatchType?;
    /**
     * @stability stable
     */
    get subjectMatchType(): string;
    /**
     * @stability stable
     */
    set subjectMatchType(value: string);
    /**
     * @stability stable
     */
    resetSubjectMatchType(): void;
    /**
     * @stability stable
     */
    get subjectMatchTypeInput(): string | undefined;
    private _suspendedAction?;
    /**
     * @stability stable
     */
    get suspendedAction(): string;
    /**
     * @stability stable
     */
    set suspendedAction(value: string);
    /**
     * @stability stable
     */
    resetSuspendedAction(): void;
    /**
     * @stability stable
     */
    get suspendedActionInput(): string | undefined;
    private _tokenBinding?;
    /**
     * @stability stable
     */
    get tokenBinding(): string;
    /**
     * @stability stable
     */
    set tokenBinding(value: string);
    /**
     * @stability stable
     */
    get tokenBindingInput(): string | undefined;
    private _tokenUrl?;
    /**
     * @stability stable
     */
    get tokenUrl(): string;
    /**
     * @stability stable
     */
    set tokenUrl(value: string);
    /**
     * @stability stable
     */
    get tokenUrlInput(): string | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    private _userInfoBinding?;
    /**
     * @stability stable
     */
    get userInfoBinding(): string;
    /**
     * @stability stable
     */
    set userInfoBinding(value: string);
    /**
     * @stability stable
     */
    resetUserInfoBinding(): void;
    /**
     * @stability stable
     */
    get userInfoBindingInput(): string | undefined;
    private _userInfoUrl?;
    /**
     * @stability stable
     */
    get userInfoUrl(): string;
    /**
     * @stability stable
     */
    set userInfoUrl(value: string);
    /**
     * @stability stable
     */
    resetUserInfoUrl(): void;
    /**
     * @stability stable
     */
    get userInfoUrlInput(): string | undefined;
    private _usernameTemplate?;
    /**
     * @stability stable
     */
    get usernameTemplate(): string;
    /**
     * @stability stable
     */
    set usernameTemplate(value: string);
    /**
     * @stability stable
     */
    resetUsernameTemplate(): void;
    /**
     * @stability stable
     */
    get usernameTemplateInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
