import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface InlineHookConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/inline_hook.html#auth InlineHook#auth}.
     *
     * @stability stable
     */
    readonly auth?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/inline_hook.html#channel InlineHook#channel}.
     *
     * @stability stable
     */
    readonly channel: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/inline_hook.html#name InlineHook#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/inline_hook.html#status InlineHook#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/inline_hook.html#type InlineHook#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/inline_hook.html#version InlineHook#version}.
     *
     * @stability stable
     */
    readonly version: string;
    /**
     * headers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/inline_hook.html#headers InlineHook#headers}
     *
     * @stability stable
     */
    readonly headers?: InlineHookHeaders[];
}
/**
 * @stability stable
 */
export interface InlineHookHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/inline_hook.html#key InlineHook#key}.
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/inline_hook.html#value InlineHook#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function inlineHookHeadersToTerraform(struct?: InlineHookHeaders): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/inline_hook.html okta_inline_hook}.
 *
 * @stability stable
 */
export declare class InlineHook extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/inline_hook.html okta_inline_hook} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: InlineHookConfig);
    private _auth?;
    /**
     * @stability stable
     */
    get auth(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set auth(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAuth(): void;
    /**
     * @stability stable
     */
    get authInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _channel?;
    /**
     * @stability stable
     */
    get channel(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set channel(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get channelInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _headers?;
    /**
     * @stability stable
     */
    get headers(): InlineHookHeaders[];
    /**
     * @stability stable
     */
    set headers(value: InlineHookHeaders[]);
    /**
     * @stability stable
     */
    resetHeaders(): void;
    /**
     * @stability stable
     */
    get headersInput(): InlineHookHeaders[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
