import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LinkDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Description of the associated relationship.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_definition.html#associated_description LinkDefinition#associated_description}
     *
     * @stability stable
     */
    readonly associatedDescription: string;
    /**
     * API name of the associated link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_definition.html#associated_name LinkDefinition#associated_name}
     *
     * @stability stable
     */
    readonly associatedName: string;
    /**
     * Display name of the associated link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_definition.html#associated_title LinkDefinition#associated_title}
     *
     * @stability stable
     */
    readonly associatedTitle: string;
    /**
     * Description of the primary relationship.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_definition.html#primary_description LinkDefinition#primary_description}
     *
     * @stability stable
     */
    readonly primaryDescription: string;
    /**
     * API name of the primary link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_definition.html#primary_name LinkDefinition#primary_name}
     *
     * @stability stable
     */
    readonly primaryName: string;
    /**
     * Display name of the primary link.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_definition.html#primary_title LinkDefinition#primary_title}
     *
     * @stability stable
     */
    readonly primaryTitle: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/link_definition.html okta_link_definition}.
 *
 * @stability stable
 */
export declare class LinkDefinition extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/link_definition.html okta_link_definition} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LinkDefinitionConfig);
    private _associatedDescription?;
    /**
     * @stability stable
     */
    get associatedDescription(): string;
    /**
     * @stability stable
     */
    set associatedDescription(value: string);
    /**
     * @stability stable
     */
    get associatedDescriptionInput(): string | undefined;
    private _associatedName?;
    /**
     * @stability stable
     */
    get associatedName(): string;
    /**
     * @stability stable
     */
    set associatedName(value: string);
    /**
     * @stability stable
     */
    get associatedNameInput(): string | undefined;
    private _associatedTitle?;
    /**
     * @stability stable
     */
    get associatedTitle(): string;
    /**
     * @stability stable
     */
    set associatedTitle(value: string);
    /**
     * @stability stable
     */
    get associatedTitleInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _primaryDescription?;
    /**
     * @stability stable
     */
    get primaryDescription(): string;
    /**
     * @stability stable
     */
    set primaryDescription(value: string);
    /**
     * @stability stable
     */
    get primaryDescriptionInput(): string | undefined;
    private _primaryName?;
    /**
     * @stability stable
     */
    get primaryName(): string;
    /**
     * @stability stable
     */
    set primaryName(value: string);
    /**
     * @stability stable
     */
    get primaryNameInput(): string | undefined;
    private _primaryTitle?;
    /**
     * @stability stable
     */
    get primaryTitle(): string;
    /**
     * @stability stable
     */
    set primaryTitle(value: string);
    /**
     * @stability stable
     */
    get primaryTitleInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
