import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LinkValueConfig extends cdktf.TerraformMetaArguments {
    /**
     * Set of User IDs or login values of the users to be assigned the 'associated' relationship.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_value.html#associated_user_ids LinkValue#associated_user_ids}
     *
     * @stability stable
     */
    readonly associatedUserIds?: string[];
    /**
     * Name of the 'primary' relationship being assigned.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_value.html#primary_name LinkValue#primary_name}
     *
     * @stability stable
     */
    readonly primaryName: string;
    /**
     * User ID to be assigned to 'primary' for the 'associated' user in the specified relationship.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/link_value.html#primary_user_id LinkValue#primary_user_id}
     *
     * @stability stable
     */
    readonly primaryUserId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/link_value.html okta_link_value}.
 *
 * @stability stable
 */
export declare class LinkValue extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/link_value.html okta_link_value} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LinkValueConfig);
    private _associatedUserIds?;
    /**
     * @stability stable
     */
    get associatedUserIds(): string[];
    /**
     * @stability stable
     */
    set associatedUserIds(value: string[]);
    /**
     * @stability stable
     */
    resetAssociatedUserIds(): void;
    /**
     * @stability stable
     */
    get associatedUserIdsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _primaryName?;
    /**
     * @stability stable
     */
    get primaryName(): string;
    /**
     * @stability stable
     */
    set primaryName(value: string);
    /**
     * @stability stable
     */
    get primaryNameInput(): string | undefined;
    private _primaryUserId?;
    /**
     * @stability stable
     */
    get primaryUserId(): string;
    /**
     * @stability stable
     */
    set primaryUserId(value: string);
    /**
     * @stability stable
     */
    get primaryUserIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
