import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MfaPolicyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Should the user be enrolled the first time they LOGIN, the next time they are CHALLENGED, or NEVER?
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#enroll MfaPolicyRule#enroll}
     *
     * @stability stable
     */
    readonly enroll?: string;
    /**
     * Policy Rule Name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#name MfaPolicyRule#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#network_connection MfaPolicyRule#network_connection}
     *
     * @stability stable
     */
    readonly networkConnection?: string;
    /**
     * The zones to exclude.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#network_excludes MfaPolicyRule#network_excludes}
     *
     * @stability stable
     */
    readonly networkExcludes?: string[];
    /**
     * The zones to include.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#network_includes MfaPolicyRule#network_includes}
     *
     * @stability stable
     */
    readonly networkIncludes?: string[];
    /**
     * Policy ID of the Rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#policy_id MfaPolicyRule#policy_id}
     *
     * @stability stable
     */
    readonly policyId?: string;
    /**
     * Policy ID of the Rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#policyid MfaPolicyRule#policyid}
     *
     * @stability stable
     */
    readonly policyid?: string;
    /**
     * Policy Rule Priority, this attribute can be set to a valid priority.
     *
     * To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#priority MfaPolicyRule#priority}
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Policy Rule Status: ACTIVE or INACTIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#status MfaPolicyRule#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Set of User IDs to Exclude.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#users_excluded MfaPolicyRule#users_excluded}
     *
     * @stability stable
     */
    readonly usersExcluded?: string[];
    /**
     * app_exclude block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#app_exclude MfaPolicyRule#app_exclude}
     *
     * @stability stable
     */
    readonly appExclude?: MfaPolicyRuleAppExclude[];
    /**
     * app_include block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#app_include MfaPolicyRule#app_include}
     *
     * @stability stable
     */
    readonly appInclude?: MfaPolicyRuleAppInclude[];
}
/**
 * @stability stable
 */
export interface MfaPolicyRuleAppExclude {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#id MfaPolicyRule#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#name MfaPolicyRule#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#type MfaPolicyRule#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function mfaPolicyRuleAppExcludeToTerraform(struct?: MfaPolicyRuleAppExclude): any;
/**
 * @stability stable
 */
export interface MfaPolicyRuleAppInclude {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#id MfaPolicyRule#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#name MfaPolicyRule#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html#type MfaPolicyRule#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function mfaPolicyRuleAppIncludeToTerraform(struct?: MfaPolicyRuleAppInclude): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html okta_mfa_policy_rule}.
 *
 * @stability stable
 */
export declare class MfaPolicyRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy_rule.html okta_mfa_policy_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MfaPolicyRuleConfig);
    private _enroll?;
    /**
     * @stability stable
     */
    get enroll(): string;
    /**
     * @stability stable
     */
    set enroll(value: string);
    /**
     * @stability stable
     */
    resetEnroll(): void;
    /**
     * @stability stable
     */
    get enrollInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkConnection?;
    /**
     * @stability stable
     */
    get networkConnection(): string;
    /**
     * @stability stable
     */
    set networkConnection(value: string);
    /**
     * @stability stable
     */
    resetNetworkConnection(): void;
    /**
     * @stability stable
     */
    get networkConnectionInput(): string | undefined;
    private _networkExcludes?;
    /**
     * @stability stable
     */
    get networkExcludes(): string[];
    /**
     * @stability stable
     */
    set networkExcludes(value: string[]);
    /**
     * @stability stable
     */
    resetNetworkExcludes(): void;
    /**
     * @stability stable
     */
    get networkExcludesInput(): string[] | undefined;
    private _networkIncludes?;
    /**
     * @stability stable
     */
    get networkIncludes(): string[];
    /**
     * @stability stable
     */
    set networkIncludes(value: string[]);
    /**
     * @stability stable
     */
    resetNetworkIncludes(): void;
    /**
     * @stability stable
     */
    get networkIncludesInput(): string[] | undefined;
    private _policyId?;
    /**
     * @stability stable
     */
    get policyId(): string;
    /**
     * @stability stable
     */
    set policyId(value: string);
    /**
     * @stability stable
     */
    resetPolicyId(): void;
    /**
     * @stability stable
     */
    get policyIdInput(): string | undefined;
    private _policyid?;
    /**
     * @stability stable
     */
    get policyid(): string;
    /**
     * @stability stable
     */
    set policyid(value: string);
    /**
     * @stability stable
     */
    resetPolicyid(): void;
    /**
     * @stability stable
     */
    get policyidInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _usersExcluded?;
    /**
     * @stability stable
     */
    get usersExcluded(): string[];
    /**
     * @stability stable
     */
    set usersExcluded(value: string[]);
    /**
     * @stability stable
     */
    resetUsersExcluded(): void;
    /**
     * @stability stable
     */
    get usersExcludedInput(): string[] | undefined;
    private _appExclude?;
    /**
     * @stability stable
     */
    get appExclude(): MfaPolicyRuleAppExclude[];
    /**
     * @stability stable
     */
    set appExclude(value: MfaPolicyRuleAppExclude[]);
    /**
     * @stability stable
     */
    resetAppExclude(): void;
    /**
     * @stability stable
     */
    get appExcludeInput(): MfaPolicyRuleAppExclude[] | undefined;
    private _appInclude?;
    /**
     * @stability stable
     */
    get appInclude(): MfaPolicyRuleAppInclude[];
    /**
     * @stability stable
     */
    set appInclude(value: MfaPolicyRuleAppInclude[]);
    /**
     * @stability stable
     */
    resetAppInclude(): void;
    /**
     * @stability stable
     */
    get appIncludeInput(): MfaPolicyRuleAppInclude[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
