import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MfaPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Policy Description.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#description MfaPolicy#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#duo MfaPolicy#duo}.
     *
     * @stability stable
     */
    readonly duo?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#fido_u2f MfaPolicy#fido_u2f}.
     *
     * @stability stable
     */
    readonly fidoU2F?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#fido_webauthn MfaPolicy#fido_webauthn}.
     *
     * @stability stable
     */
    readonly fidoWebauthn?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#google_otp MfaPolicy#google_otp}.
     *
     * @stability stable
     */
    readonly googleOtp?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * List of Group IDs to Include.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#groups_included MfaPolicy#groups_included}
     *
     * @stability stable
     */
    readonly groupsIncluded?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#hotp MfaPolicy#hotp}.
     *
     * @stability stable
     */
    readonly hotp?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Policy Name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#name MfaPolicy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#okta_call MfaPolicy#okta_call}.
     *
     * @stability stable
     */
    readonly oktaCall?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#okta_email MfaPolicy#okta_email}.
     *
     * @stability stable
     */
    readonly oktaEmail?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#okta_otp MfaPolicy#okta_otp}.
     *
     * @stability stable
     */
    readonly oktaOtp?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#okta_password MfaPolicy#okta_password}.
     *
     * @stability stable
     */
    readonly oktaPassword?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#okta_push MfaPolicy#okta_push}.
     *
     * @stability stable
     */
    readonly oktaPush?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#okta_question MfaPolicy#okta_question}.
     *
     * @stability stable
     */
    readonly oktaQuestion?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#okta_sms MfaPolicy#okta_sms}.
     *
     * @stability stable
     */
    readonly oktaSms?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Policy Priority, this attribute can be set to a valid priority.
     *
     * To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#priority MfaPolicy#priority}
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#rsa_token MfaPolicy#rsa_token}.
     *
     * @stability stable
     */
    readonly rsaToken?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Policy Status: ACTIVE or INACTIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#status MfaPolicy#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#symantec_vip MfaPolicy#symantec_vip}.
     *
     * @stability stable
     */
    readonly symantecVip?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html#yubikey_token MfaPolicy#yubikey_token}.
     *
     * @stability stable
     */
    readonly yubikeyToken?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html okta_mfa_policy}.
 *
 * @stability stable
 */
export declare class MfaPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/mfa_policy.html okta_mfa_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MfaPolicyConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _duo?;
    /**
     * @stability stable
     */
    get duo(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set duo(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDuo(): void;
    /**
     * @stability stable
     */
    get duoInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _fidoU2F?;
    /**
     * @stability stable
     */
    get fidoU2F(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set fidoU2F(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFidoU2F(): void;
    /**
     * @stability stable
     */
    get fidoU2FInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _fidoWebauthn?;
    /**
     * @stability stable
     */
    get fidoWebauthn(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set fidoWebauthn(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFidoWebauthn(): void;
    /**
     * @stability stable
     */
    get fidoWebauthnInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _googleOtp?;
    /**
     * @stability stable
     */
    get googleOtp(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set googleOtp(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGoogleOtp(): void;
    /**
     * @stability stable
     */
    get googleOtpInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _groupsIncluded?;
    /**
     * @stability stable
     */
    get groupsIncluded(): string[];
    /**
     * @stability stable
     */
    set groupsIncluded(value: string[]);
    /**
     * @stability stable
     */
    resetGroupsIncluded(): void;
    /**
     * @stability stable
     */
    get groupsIncludedInput(): string[] | undefined;
    private _hotp?;
    /**
     * @stability stable
     */
    get hotp(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hotp(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHotp(): void;
    /**
     * @stability stable
     */
    get hotpInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _oktaCall?;
    /**
     * @stability stable
     */
    get oktaCall(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oktaCall(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOktaCall(): void;
    /**
     * @stability stable
     */
    get oktaCallInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _oktaEmail?;
    /**
     * @stability stable
     */
    get oktaEmail(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oktaEmail(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOktaEmail(): void;
    /**
     * @stability stable
     */
    get oktaEmailInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _oktaOtp?;
    /**
     * @stability stable
     */
    get oktaOtp(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oktaOtp(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOktaOtp(): void;
    /**
     * @stability stable
     */
    get oktaOtpInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _oktaPassword?;
    /**
     * @stability stable
     */
    get oktaPassword(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oktaPassword(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOktaPassword(): void;
    /**
     * @stability stable
     */
    get oktaPasswordInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _oktaPush?;
    /**
     * @stability stable
     */
    get oktaPush(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oktaPush(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOktaPush(): void;
    /**
     * @stability stable
     */
    get oktaPushInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _oktaQuestion?;
    /**
     * @stability stable
     */
    get oktaQuestion(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oktaQuestion(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOktaQuestion(): void;
    /**
     * @stability stable
     */
    get oktaQuestionInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _oktaSms?;
    /**
     * @stability stable
     */
    get oktaSms(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oktaSms(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOktaSms(): void;
    /**
     * @stability stable
     */
    get oktaSmsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _rsaToken?;
    /**
     * @stability stable
     */
    get rsaToken(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set rsaToken(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRsaToken(): void;
    /**
     * @stability stable
     */
    get rsaTokenInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _symantecVip?;
    /**
     * @stability stable
     */
    get symantecVip(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set symantecVip(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSymantecVip(): void;
    /**
     * @stability stable
     */
    get symantecVipInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _yubikeyToken?;
    /**
     * @stability stable
     */
    get yubikeyToken(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set yubikeyToken(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetYubikeyToken(): void;
    /**
     * @stability stable
     */
    get yubikeyTokenInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
