import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkZoneConfig extends cdktf.TerraformMetaArguments {
    /**
     * Format of each array value: a string representation of an ASN numeric value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone.html#asns NetworkZone#asns}
     *
     * @stability stable
     */
    readonly asns?: string[];
    /**
     * Array of locations ISO-3166-1(2). Format code: countryCode OR countryCode-regionCode.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone.html#dynamic_locations NetworkZone#dynamic_locations}
     *
     * @stability stable
     */
    readonly dynamicLocations?: string[];
    /**
     * Type of proxy being controlled by this network zone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone.html#dynamic_proxy_type NetworkZone#dynamic_proxy_type}
     *
     * @stability stable
     */
    readonly dynamicProxyType?: string;
    /**
     * Array of values in CIDR/range form depending on the way it's been declared (i.e. CIDR will contain /suffix). Please check API docs for examples.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone.html#gateways NetworkZone#gateways}
     *
     * @stability stable
     */
    readonly gateways?: string[];
    /**
     * Name of the Network Zone Resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone.html#name NetworkZone#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Array of values in CIDR/range form depending on the way it's been declared (i.e. CIDR will contain /suffix). Please check API docs for examples.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone.html#proxies NetworkZone#proxies}
     *
     * @stability stable
     */
    readonly proxies?: string[];
    /**
     * Type of the Network Zone - can either be IP or DYNAMIC only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone.html#type NetworkZone#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Zone's purpose: POLICY or BLOCKLIST.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/network_zone.html#usage NetworkZone#usage}
     *
     * @stability stable
     */
    readonly usage?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/network_zone.html okta_network_zone}.
 *
 * @stability stable
 */
export declare class NetworkZone extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/network_zone.html okta_network_zone} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkZoneConfig);
    private _asns?;
    /**
     * @stability stable
     */
    get asns(): string[];
    /**
     * @stability stable
     */
    set asns(value: string[]);
    /**
     * @stability stable
     */
    resetAsns(): void;
    /**
     * @stability stable
     */
    get asnsInput(): string[] | undefined;
    private _dynamicLocations?;
    /**
     * @stability stable
     */
    get dynamicLocations(): string[];
    /**
     * @stability stable
     */
    set dynamicLocations(value: string[]);
    /**
     * @stability stable
     */
    resetDynamicLocations(): void;
    /**
     * @stability stable
     */
    get dynamicLocationsInput(): string[] | undefined;
    private _dynamicProxyType?;
    /**
     * @stability stable
     */
    get dynamicProxyType(): string;
    /**
     * @stability stable
     */
    set dynamicProxyType(value: string);
    /**
     * @stability stable
     */
    resetDynamicProxyType(): void;
    /**
     * @stability stable
     */
    get dynamicProxyTypeInput(): string | undefined;
    private _gateways?;
    /**
     * @stability stable
     */
    get gateways(): string[];
    /**
     * @stability stable
     */
    set gateways(value: string[]);
    /**
     * @stability stable
     */
    resetGateways(): void;
    /**
     * @stability stable
     */
    get gatewaysInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _proxies?;
    /**
     * @stability stable
     */
    get proxies(): string[];
    /**
     * @stability stable
     */
    set proxies(value: string[]);
    /**
     * @stability stable
     */
    resetProxies(): void;
    /**
     * @stability stable
     */
    get proxiesInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _usage?;
    /**
     * @stability stable
     */
    get usage(): string;
    /**
     * @stability stable
     */
    set usage(value: string);
    /**
     * @stability stable
     */
    resetUsage(): void;
    /**
     * @stability stable
     */
    get usageInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
