import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OauthAppRedirectUriConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app_redirect_uri.html#app_id OauthAppRedirectUri#app_id}.
     *
     * @stability stable
     */
    readonly appId: string;
    /**
     * Redirect URI to append to Okta OIDC application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/oauth_app_redirect_uri.html#uri OauthAppRedirectUri#uri}
     *
     * @stability stable
     */
    readonly uri: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/oauth_app_redirect_uri.html okta_oauth_app_redirect_uri}.
 *
 * @stability stable
 */
export declare class OauthAppRedirectUri extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/oauth_app_redirect_uri.html okta_oauth_app_redirect_uri} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: OauthAppRedirectUriConfig);
    private _appId?;
    /**
     * @stability stable
     */
    get appId(): string;
    /**
     * @stability stable
     */
    set appId(value: string);
    /**
     * @stability stable
     */
    get appIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _uri?;
    /**
     * @stability stable
     */
    get uri(): string;
    /**
     * @stability stable
     */
    set uri(value: string);
    /**
     * @stability stable
     */
    get uriInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
