import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OktaProviderConfig {
    /**
     * API Token granting privileges to Okta API.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#api_token OktaProvider#api_token}
     *
     * @stability stable
     */
    readonly apiToken?: string;
    /**
     * Use exponential back off strategy for rate limits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#backoff OktaProvider#backoff}
     *
     * @stability stable
     */
    readonly backoff?: boolean | cdktf.IResolvable;
    /**
     * The Okta url. (Use 'oktapreview.com' for Okta testing).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#base_url OktaProvider#base_url}
     *
     * @stability stable
     */
    readonly baseUrl?: string;
    /**
     * API Token granting privileges to Okta API.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#client_id OktaProvider#client_id}
     *
     * @stability stable
     */
    readonly clientId?: string;
    /**
     * providers log level. Minimum is 1 (TRACE), and maximum is 5 (ERROR).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#log_level OktaProvider#log_level}
     *
     * @stability stable
     */
    readonly logLevel?: number;
    /**
     * (Experimental) sets what percentage of capacity the provider can use of the total rate limit capacity while making calls to the Okta management API endpoints.
     *
     * Okta API operates in one minute buckets. See Okta Management API Rate Limits: https://developer.okta.com/docs/reference/rl-global-mgmt/
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#max_api_capacity OktaProvider#max_api_capacity}
     *
     * @stability stable
     */
    readonly maxApiCapacity?: number;
    /**
     * maximum number of retries to attempt before erroring out.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#max_retries OktaProvider#max_retries}
     *
     * @stability stable
     */
    readonly maxRetries?: number;
    /**
     * maximum seconds to wait when rate limit is hit. We use exponential backoffs when backoff is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#max_wait_seconds OktaProvider#max_wait_seconds}
     *
     * @stability stable
     */
    readonly maxWaitSeconds?: number;
    /**
     * minimum seconds to wait when rate limit is hit. We use exponential backoffs when backoff is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#min_wait_seconds OktaProvider#min_wait_seconds}
     *
     * @stability stable
     */
    readonly minWaitSeconds?: number;
    /**
     * The organization to manage in Okta.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#org_name OktaProvider#org_name}
     *
     * @stability stable
     */
    readonly orgName?: string;
    /**
     * Number of concurrent requests to make within a resource where bulk operations are not possible. Take note of https://developer.okta.com/docs/api/getting_started/rate-limits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#parallelism OktaProvider#parallelism}
     *
     * @stability stable
     */
    readonly parallelism?: number;
    /**
     * API Token granting privileges to Okta API.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#private_key OktaProvider#private_key}
     *
     * @stability stable
     */
    readonly privateKey?: string;
    /**
     * Timeout for single request (in seconds) which is made to Okta, the default is `0` (means no limit is set).
     *
     * The maximum value can be `300`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#request_timeout OktaProvider#request_timeout}
     *
     * @stability stable
     */
    readonly requestTimeout?: number;
    /**
     * API Token granting privileges to Okta API.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#scopes OktaProvider#scopes}
     *
     * @stability stable
     */
    readonly scopes?: string[];
    /**
     * Alias name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta#alias OktaProvider#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta okta}.
 *
 * @stability stable
 */
export declare class OktaProvider extends cdktf.TerraformProvider {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta okta} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: OktaProviderConfig);
    private _apiToken?;
    /**
     * @stability stable
     */
    get apiToken(): string | undefined;
    /**
     * @stability stable
     */
    set apiToken(value: string | undefined);
    /**
     * @stability stable
     */
    resetApiToken(): void;
    /**
     * @stability stable
     */
    get apiTokenInput(): string | undefined;
    private _backoff?;
    /**
     * @stability stable
     */
    get backoff(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set backoff(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetBackoff(): void;
    /**
     * @stability stable
     */
    get backoffInput(): boolean | cdktf.IResolvable | undefined;
    private _baseUrl?;
    /**
     * @stability stable
     */
    get baseUrl(): string | undefined;
    /**
     * @stability stable
     */
    set baseUrl(value: string | undefined);
    /**
     * @stability stable
     */
    resetBaseUrl(): void;
    /**
     * @stability stable
     */
    get baseUrlInput(): string | undefined;
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string | undefined;
    /**
     * @stability stable
     */
    set clientId(value: string | undefined);
    /**
     * @stability stable
     */
    resetClientId(): void;
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _logLevel?;
    /**
     * @stability stable
     */
    get logLevel(): number | undefined;
    /**
     * @stability stable
     */
    set logLevel(value: number | undefined);
    /**
     * @stability stable
     */
    resetLogLevel(): void;
    /**
     * @stability stable
     */
    get logLevelInput(): number | undefined;
    private _maxApiCapacity?;
    /**
     * @stability stable
     */
    get maxApiCapacity(): number | undefined;
    /**
     * @stability stable
     */
    set maxApiCapacity(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxApiCapacity(): void;
    /**
     * @stability stable
     */
    get maxApiCapacityInput(): number | undefined;
    private _maxRetries?;
    /**
     * @stability stable
     */
    get maxRetries(): number | undefined;
    /**
     * @stability stable
     */
    set maxRetries(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxRetries(): void;
    /**
     * @stability stable
     */
    get maxRetriesInput(): number | undefined;
    private _maxWaitSeconds?;
    /**
     * @stability stable
     */
    get maxWaitSeconds(): number | undefined;
    /**
     * @stability stable
     */
    set maxWaitSeconds(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxWaitSeconds(): void;
    /**
     * @stability stable
     */
    get maxWaitSecondsInput(): number | undefined;
    private _minWaitSeconds?;
    /**
     * @stability stable
     */
    get minWaitSeconds(): number | undefined;
    /**
     * @stability stable
     */
    set minWaitSeconds(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinWaitSeconds(): void;
    /**
     * @stability stable
     */
    get minWaitSecondsInput(): number | undefined;
    private _orgName?;
    /**
     * @stability stable
     */
    get orgName(): string | undefined;
    /**
     * @stability stable
     */
    set orgName(value: string | undefined);
    /**
     * @stability stable
     */
    resetOrgName(): void;
    /**
     * @stability stable
     */
    get orgNameInput(): string | undefined;
    private _parallelism?;
    /**
     * @stability stable
     */
    get parallelism(): number | undefined;
    /**
     * @stability stable
     */
    set parallelism(value: number | undefined);
    /**
     * @stability stable
     */
    resetParallelism(): void;
    /**
     * @stability stable
     */
    get parallelismInput(): number | undefined;
    private _privateKey?;
    /**
     * @stability stable
     */
    get privateKey(): string | undefined;
    /**
     * @stability stable
     */
    set privateKey(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrivateKey(): void;
    /**
     * @stability stable
     */
    get privateKeyInput(): string | undefined;
    private _requestTimeout?;
    /**
     * @stability stable
     */
    get requestTimeout(): number | undefined;
    /**
     * @stability stable
     */
    set requestTimeout(value: number | undefined);
    /**
     * @stability stable
     */
    resetRequestTimeout(): void;
    /**
     * @stability stable
     */
    get requestTimeoutInput(): number | undefined;
    private _scopes?;
    /**
     * @stability stable
     */
    get scopes(): string[] | undefined;
    /**
     * @stability stable
     */
    set scopes(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetScopes(): void;
    /**
     * @stability stable
     */
    get scopesInput(): string[] | undefined;
    private _alias?;
    /**
     * @stability stable
     */
    get alias(): string | undefined;
    /**
     * @stability stable
     */
    set alias(value: string | undefined);
    /**
     * @stability stable
     */
    resetAlias(): void;
    /**
     * @stability stable
     */
    get aliasInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
