import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OrgConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Primary address of org.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html#address_1 OrgConfiguration#address_1}
     *
     * @stability stable
     */
    readonly address1?: string;
    /**
     * Secondary address of org.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html#address_2 OrgConfiguration#address_2}
     *
     * @stability stable
     */
    readonly address2?: string;
    /**
     * User ID representing the billing contact.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html#billing_contact_user OrgConfiguration#billing_contact_user}
     *
     * @stability stable
     */
    readonly billingContactUser?: string;
    /**
     * City of org.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html#city OrgConfiguration#city}
     *
     * @stability stable
     */
    readonly city?: string;
    /**
     * Name of org.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html#company_name OrgConfiguration#company_name}
     *
     * @stability stable
     */
    readonly companyName: string;
    /**
     * Country of org.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html#country OrgConfiguration#country}
     *
     * @stability stable
     */
    readonly country?: string;
    /**
     * Support link of org.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html#end_user_support_help_url OrgConfiguration#end_user_support_help_url}
     *
     * @stability stable
     */
    readonly endUserSupportHelpUrl?: string;
    /**
     * Local path to logo of the org.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html#logo OrgConfiguration#logo}
     *
     * @stability stable
     */
    readonly logo?: string;
    /**
     * Indicates whether the org's users receive Okta Communication emails.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html#opt_out_communication_emails OrgConfiguration#opt_out_communication_emails}
     *
     * @stability stable
     */
    readonly optOutCommunicationEmails?: boolean | cdktf.IResolvable;
    /**
     * Support help phone of org.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html#phone_number OrgConfiguration#phone_number}
     *
     * @stability stable
     */
    readonly phoneNumber?: string;
    /**
     * Postal code of org.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html#postal_code OrgConfiguration#postal_code}
     *
     * @stability stable
     */
    readonly postalCode?: string;
    /**
     * State of org.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html#state OrgConfiguration#state}
     *
     * @stability stable
     */
    readonly state?: string;
    /**
     * Support help phone of org.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html#support_phone_number OrgConfiguration#support_phone_number}
     *
     * @stability stable
     */
    readonly supportPhoneNumber?: string;
    /**
     * User ID representing the technical contact.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html#technical_contact_user OrgConfiguration#technical_contact_user}
     *
     * @stability stable
     */
    readonly technicalContactUser?: string;
    /**
     * The org's website.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html#website OrgConfiguration#website}
     *
     * @stability stable
     */
    readonly website?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html okta_org_configuration}.
 *
 * @stability stable
 */
export declare class OrgConfiguration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/org_configuration.html okta_org_configuration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: OrgConfigurationConfig);
    private _address1?;
    /**
     * @stability stable
     */
    get address1(): string;
    /**
     * @stability stable
     */
    set address1(value: string);
    /**
     * @stability stable
     */
    resetAddress1(): void;
    /**
     * @stability stable
     */
    get address1Input(): string | undefined;
    private _address2?;
    /**
     * @stability stable
     */
    get address2(): string;
    /**
     * @stability stable
     */
    set address2(value: string);
    /**
     * @stability stable
     */
    resetAddress2(): void;
    /**
     * @stability stable
     */
    get address2Input(): string | undefined;
    private _billingContactUser?;
    /**
     * @stability stable
     */
    get billingContactUser(): string;
    /**
     * @stability stable
     */
    set billingContactUser(value: string);
    /**
     * @stability stable
     */
    resetBillingContactUser(): void;
    /**
     * @stability stable
     */
    get billingContactUserInput(): string | undefined;
    private _city?;
    /**
     * @stability stable
     */
    get city(): string;
    /**
     * @stability stable
     */
    set city(value: string);
    /**
     * @stability stable
     */
    resetCity(): void;
    /**
     * @stability stable
     */
    get cityInput(): string | undefined;
    private _companyName?;
    /**
     * @stability stable
     */
    get companyName(): string;
    /**
     * @stability stable
     */
    set companyName(value: string);
    /**
     * @stability stable
     */
    get companyNameInput(): string | undefined;
    private _country?;
    /**
     * @stability stable
     */
    get country(): string;
    /**
     * @stability stable
     */
    set country(value: string);
    /**
     * @stability stable
     */
    resetCountry(): void;
    /**
     * @stability stable
     */
    get countryInput(): string | undefined;
    private _endUserSupportHelpUrl?;
    /**
     * @stability stable
     */
    get endUserSupportHelpUrl(): string;
    /**
     * @stability stable
     */
    set endUserSupportHelpUrl(value: string);
    /**
     * @stability stable
     */
    resetEndUserSupportHelpUrl(): void;
    /**
     * @stability stable
     */
    get endUserSupportHelpUrlInput(): string | undefined;
    /**
     * @stability stable
     */
    get expiresAt(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _logo?;
    /**
     * @stability stable
     */
    get logo(): string;
    /**
     * @stability stable
     */
    set logo(value: string);
    /**
     * @stability stable
     */
    resetLogo(): void;
    /**
     * @stability stable
     */
    get logoInput(): string | undefined;
    private _optOutCommunicationEmails?;
    /**
     * @stability stable
     */
    get optOutCommunicationEmails(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set optOutCommunicationEmails(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOptOutCommunicationEmails(): void;
    /**
     * @stability stable
     */
    get optOutCommunicationEmailsInput(): boolean | cdktf.IResolvable | undefined;
    private _phoneNumber?;
    /**
     * @stability stable
     */
    get phoneNumber(): string;
    /**
     * @stability stable
     */
    set phoneNumber(value: string);
    /**
     * @stability stable
     */
    resetPhoneNumber(): void;
    /**
     * @stability stable
     */
    get phoneNumberInput(): string | undefined;
    private _postalCode?;
    /**
     * @stability stable
     */
    get postalCode(): string;
    /**
     * @stability stable
     */
    set postalCode(value: string);
    /**
     * @stability stable
     */
    resetPostalCode(): void;
    /**
     * @stability stable
     */
    get postalCodeInput(): string | undefined;
    private _state?;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    set state(value: string);
    /**
     * @stability stable
     */
    resetState(): void;
    /**
     * @stability stable
     */
    get stateInput(): string | undefined;
    /**
     * @stability stable
     */
    get subdomain(): string;
    private _supportPhoneNumber?;
    /**
     * @stability stable
     */
    get supportPhoneNumber(): string;
    /**
     * @stability stable
     */
    set supportPhoneNumber(value: string);
    /**
     * @stability stable
     */
    resetSupportPhoneNumber(): void;
    /**
     * @stability stable
     */
    get supportPhoneNumberInput(): string | undefined;
    private _technicalContactUser?;
    /**
     * @stability stable
     */
    get technicalContactUser(): string;
    /**
     * @stability stable
     */
    set technicalContactUser(value: string);
    /**
     * @stability stable
     */
    resetTechnicalContactUser(): void;
    /**
     * @stability stable
     */
    get technicalContactUserInput(): string | undefined;
    private _website?;
    /**
     * @stability stable
     */
    get website(): string;
    /**
     * @stability stable
     */
    set website(value: string);
    /**
     * @stability stable
     */
    resetWebsite(): void;
    /**
     * @stability stable
     */
    get websiteInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
