import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OrgSupportConfig extends cdktf.TerraformMetaArguments {
    /**
     * Number of days the support should be extended by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/org_support.html#extend_by OrgSupport#extend_by}
     *
     * @stability stable
     */
    readonly extendBy?: number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/org_support.html okta_org_support}.
 *
 * @stability stable
 */
export declare class OrgSupport extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/org_support.html okta_org_support} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: OrgSupportConfig);
    /**
     * @stability stable
     */
    get expiration(): string;
    private _extendBy?;
    /**
     * @stability stable
     */
    get extendBy(): number;
    /**
     * @stability stable
     */
    set extendBy(value: number);
    /**
     * @stability stable
     */
    resetExtendBy(): void;
    /**
     * @stability stable
     */
    get extendByInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
