import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PasswordPolicyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Policy Rule Name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/password_policy_rule.html#name PasswordPolicyRule#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/password_policy_rule.html#network_connection PasswordPolicyRule#network_connection}
     *
     * @stability stable
     */
    readonly networkConnection?: string;
    /**
     * The zones to exclude.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/password_policy_rule.html#network_excludes PasswordPolicyRule#network_excludes}
     *
     * @stability stable
     */
    readonly networkExcludes?: string[];
    /**
     * The zones to include.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/password_policy_rule.html#network_includes PasswordPolicyRule#network_includes}
     *
     * @stability stable
     */
    readonly networkIncludes?: string[];
    /**
     * Allow or deny a user to change their password: ALLOW or DENY. Default = ALLOW.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/password_policy_rule.html#password_change PasswordPolicyRule#password_change}
     *
     * @stability stable
     */
    readonly passwordChange?: string;
    /**
     * Allow or deny a user to reset their password: ALLOW or DENY. Default = ALLOW.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/password_policy_rule.html#password_reset PasswordPolicyRule#password_reset}
     *
     * @stability stable
     */
    readonly passwordReset?: string;
    /**
     * Allow or deny a user to unlock. Default = DENY.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/password_policy_rule.html#password_unlock PasswordPolicyRule#password_unlock}
     *
     * @stability stable
     */
    readonly passwordUnlock?: string;
    /**
     * Policy ID of the Rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/password_policy_rule.html#policy_id PasswordPolicyRule#policy_id}
     *
     * @stability stable
     */
    readonly policyId?: string;
    /**
     * Policy ID of the Rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/password_policy_rule.html#policyid PasswordPolicyRule#policyid}
     *
     * @stability stable
     */
    readonly policyid?: string;
    /**
     * Policy Rule Priority, this attribute can be set to a valid priority.
     *
     * To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/password_policy_rule.html#priority PasswordPolicyRule#priority}
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Policy Rule Status: ACTIVE or INACTIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/password_policy_rule.html#status PasswordPolicyRule#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Set of User IDs to Exclude.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/password_policy_rule.html#users_excluded PasswordPolicyRule#users_excluded}
     *
     * @stability stable
     */
    readonly usersExcluded?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/password_policy_rule.html okta_password_policy_rule}.
 *
 * @stability stable
 */
export declare class PasswordPolicyRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/password_policy_rule.html okta_password_policy_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PasswordPolicyRuleConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkConnection?;
    /**
     * @stability stable
     */
    get networkConnection(): string;
    /**
     * @stability stable
     */
    set networkConnection(value: string);
    /**
     * @stability stable
     */
    resetNetworkConnection(): void;
    /**
     * @stability stable
     */
    get networkConnectionInput(): string | undefined;
    private _networkExcludes?;
    /**
     * @stability stable
     */
    get networkExcludes(): string[];
    /**
     * @stability stable
     */
    set networkExcludes(value: string[]);
    /**
     * @stability stable
     */
    resetNetworkExcludes(): void;
    /**
     * @stability stable
     */
    get networkExcludesInput(): string[] | undefined;
    private _networkIncludes?;
    /**
     * @stability stable
     */
    get networkIncludes(): string[];
    /**
     * @stability stable
     */
    set networkIncludes(value: string[]);
    /**
     * @stability stable
     */
    resetNetworkIncludes(): void;
    /**
     * @stability stable
     */
    get networkIncludesInput(): string[] | undefined;
    private _passwordChange?;
    /**
     * @stability stable
     */
    get passwordChange(): string;
    /**
     * @stability stable
     */
    set passwordChange(value: string);
    /**
     * @stability stable
     */
    resetPasswordChange(): void;
    /**
     * @stability stable
     */
    get passwordChangeInput(): string | undefined;
    private _passwordReset?;
    /**
     * @stability stable
     */
    get passwordReset(): string;
    /**
     * @stability stable
     */
    set passwordReset(value: string);
    /**
     * @stability stable
     */
    resetPasswordReset(): void;
    /**
     * @stability stable
     */
    get passwordResetInput(): string | undefined;
    private _passwordUnlock?;
    /**
     * @stability stable
     */
    get passwordUnlock(): string;
    /**
     * @stability stable
     */
    set passwordUnlock(value: string);
    /**
     * @stability stable
     */
    resetPasswordUnlock(): void;
    /**
     * @stability stable
     */
    get passwordUnlockInput(): string | undefined;
    private _policyId?;
    /**
     * @stability stable
     */
    get policyId(): string;
    /**
     * @stability stable
     */
    set policyId(value: string);
    /**
     * @stability stable
     */
    resetPolicyId(): void;
    /**
     * @stability stable
     */
    get policyIdInput(): string | undefined;
    private _policyid?;
    /**
     * @stability stable
     */
    get policyid(): string;
    /**
     * @stability stable
     */
    set policyid(value: string);
    /**
     * @stability stable
     */
    resetPolicyid(): void;
    /**
     * @stability stable
     */
    get policyidInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _usersExcluded?;
    /**
     * @stability stable
     */
    get usersExcluded(): string[];
    /**
     * @stability stable
     */
    set usersExcluded(value: string[]);
    /**
     * @stability stable
     */
    resetUsersExcluded(): void;
    /**
     * @stability stable
     */
    get usersExcludedInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
