import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PolicyMfaDefaultConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html#duo PolicyMfaDefault#duo}.
     *
     * @stability stable
     */
    readonly duo?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html#fido_u2f PolicyMfaDefault#fido_u2f}.
     *
     * @stability stable
     */
    readonly fidoU2F?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html#fido_webauthn PolicyMfaDefault#fido_webauthn}.
     *
     * @stability stable
     */
    readonly fidoWebauthn?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html#google_otp PolicyMfaDefault#google_otp}.
     *
     * @stability stable
     */
    readonly googleOtp?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html#hotp PolicyMfaDefault#hotp}.
     *
     * @stability stable
     */
    readonly hotp?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html#okta_call PolicyMfaDefault#okta_call}.
     *
     * @stability stable
     */
    readonly oktaCall?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html#okta_email PolicyMfaDefault#okta_email}.
     *
     * @stability stable
     */
    readonly oktaEmail?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html#okta_otp PolicyMfaDefault#okta_otp}.
     *
     * @stability stable
     */
    readonly oktaOtp?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html#okta_password PolicyMfaDefault#okta_password}.
     *
     * @stability stable
     */
    readonly oktaPassword?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html#okta_push PolicyMfaDefault#okta_push}.
     *
     * @stability stable
     */
    readonly oktaPush?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html#okta_question PolicyMfaDefault#okta_question}.
     *
     * @stability stable
     */
    readonly oktaQuestion?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html#okta_sms PolicyMfaDefault#okta_sms}.
     *
     * @stability stable
     */
    readonly oktaSms?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html#rsa_token PolicyMfaDefault#rsa_token}.
     *
     * @stability stable
     */
    readonly rsaToken?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html#symantec_vip PolicyMfaDefault#symantec_vip}.
     *
     * @stability stable
     */
    readonly symantecVip?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html#yubikey_token PolicyMfaDefault#yubikey_token}.
     *
     * @stability stable
     */
    readonly yubikeyToken?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html okta_policy_mfa_default}.
 *
 * @stability stable
 */
export declare class PolicyMfaDefault extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_mfa_default.html okta_policy_mfa_default} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: PolicyMfaDefaultConfig);
    /**
     * @stability stable
     */
    get defaultIncludedGroupId(): string;
    /**
     * @stability stable
     */
    get description(): string;
    private _duo?;
    /**
     * @stability stable
     */
    get duo(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set duo(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDuo(): void;
    /**
     * @stability stable
     */
    get duoInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _fidoU2F?;
    /**
     * @stability stable
     */
    get fidoU2F(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set fidoU2F(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFidoU2F(): void;
    /**
     * @stability stable
     */
    get fidoU2FInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _fidoWebauthn?;
    /**
     * @stability stable
     */
    get fidoWebauthn(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set fidoWebauthn(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFidoWebauthn(): void;
    /**
     * @stability stable
     */
    get fidoWebauthnInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _googleOtp?;
    /**
     * @stability stable
     */
    get googleOtp(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set googleOtp(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGoogleOtp(): void;
    /**
     * @stability stable
     */
    get googleOtpInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _hotp?;
    /**
     * @stability stable
     */
    get hotp(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hotp(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHotp(): void;
    /**
     * @stability stable
     */
    get hotpInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _oktaCall?;
    /**
     * @stability stable
     */
    get oktaCall(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oktaCall(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOktaCall(): void;
    /**
     * @stability stable
     */
    get oktaCallInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _oktaEmail?;
    /**
     * @stability stable
     */
    get oktaEmail(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oktaEmail(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOktaEmail(): void;
    /**
     * @stability stable
     */
    get oktaEmailInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _oktaOtp?;
    /**
     * @stability stable
     */
    get oktaOtp(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oktaOtp(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOktaOtp(): void;
    /**
     * @stability stable
     */
    get oktaOtpInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _oktaPassword?;
    /**
     * @stability stable
     */
    get oktaPassword(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oktaPassword(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOktaPassword(): void;
    /**
     * @stability stable
     */
    get oktaPasswordInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _oktaPush?;
    /**
     * @stability stable
     */
    get oktaPush(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oktaPush(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOktaPush(): void;
    /**
     * @stability stable
     */
    get oktaPushInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _oktaQuestion?;
    /**
     * @stability stable
     */
    get oktaQuestion(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oktaQuestion(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOktaQuestion(): void;
    /**
     * @stability stable
     */
    get oktaQuestionInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _oktaSms?;
    /**
     * @stability stable
     */
    get oktaSms(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set oktaSms(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOktaSms(): void;
    /**
     * @stability stable
     */
    get oktaSmsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get priority(): number;
    private _rsaToken?;
    /**
     * @stability stable
     */
    get rsaToken(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set rsaToken(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRsaToken(): void;
    /**
     * @stability stable
     */
    get rsaTokenInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _symantecVip?;
    /**
     * @stability stable
     */
    get symantecVip(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set symantecVip(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSymantecVip(): void;
    /**
     * @stability stable
     */
    get symantecVipInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _yubikeyToken?;
    /**
     * @stability stable
     */
    get yubikeyToken(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set yubikeyToken(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetYubikeyToken(): void;
    /**
     * @stability stable
     */
    get yubikeyTokenInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
