"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyPasswordDefault = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default.html okta_policy_password_default}.
 *
 * @stability stable
 */
class PolicyPasswordDefault extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_password_default.html okta_policy_password_default} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'okta_policy_password_default',
            terraformGeneratorMetadata: {
                providerName: 'okta'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._callRecovery = config.callRecovery;
        this._emailRecovery = config.emailRecovery;
        this._passwordAutoUnlockMinutes = config.passwordAutoUnlockMinutes;
        this._passwordDictionaryLookup = config.passwordDictionaryLookup;
        this._passwordExcludeFirstName = config.passwordExcludeFirstName;
        this._passwordExcludeLastName = config.passwordExcludeLastName;
        this._passwordExcludeUsername = config.passwordExcludeUsername;
        this._passwordExpireWarnDays = config.passwordExpireWarnDays;
        this._passwordHistoryCount = config.passwordHistoryCount;
        this._passwordLockoutNotificationChannels = config.passwordLockoutNotificationChannels;
        this._passwordMaxAgeDays = config.passwordMaxAgeDays;
        this._passwordMaxLockoutAttempts = config.passwordMaxLockoutAttempts;
        this._passwordMinAgeMinutes = config.passwordMinAgeMinutes;
        this._passwordMinLength = config.passwordMinLength;
        this._passwordMinLowercase = config.passwordMinLowercase;
        this._passwordMinNumber = config.passwordMinNumber;
        this._passwordMinSymbol = config.passwordMinSymbol;
        this._passwordMinUppercase = config.passwordMinUppercase;
        this._passwordShowLockoutFailures = config.passwordShowLockoutFailures;
        this._questionMinLength = config.questionMinLength;
        this._questionRecovery = config.questionRecovery;
        this._recoveryEmailToken = config.recoveryEmailToken;
        this._skipUnlock = config.skipUnlock;
        this._smsRecovery = config.smsRecovery;
    }
    /**
     * @stability stable
     */
    get callRecovery() {
        return this.getStringAttribute('call_recovery');
    }
    /**
     * @stability stable
     */
    set callRecovery(value) {
        this._callRecovery = value;
    }
    /**
     * @stability stable
     */
    resetCallRecovery() {
        this._callRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get callRecoveryInput() {
        return this._callRecovery;
    }
    // default_auth_provider - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get defaultAuthProvider() {
        return this.getStringAttribute('default_auth_provider');
    }
    // default_included_group_id - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get defaultIncludedGroupId() {
        return this.getStringAttribute('default_included_group_id');
    }
    // description - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get description() {
        return this.getStringAttribute('description');
    }
    /**
     * @stability stable
     */
    get emailRecovery() {
        return this.getStringAttribute('email_recovery');
    }
    /**
     * @stability stable
     */
    set emailRecovery(value) {
        this._emailRecovery = value;
    }
    /**
     * @stability stable
     */
    resetEmailRecovery() {
        this._emailRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get emailRecoveryInput() {
        return this._emailRecovery;
    }
    // id - computed: true, optional: true, required: false
    /**
     * @stability stable
     */
    get id() {
        return this.getStringAttribute('id');
    }
    // name - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get name() {
        return this.getStringAttribute('name');
    }
    /**
     * @stability stable
     */
    get passwordAutoUnlockMinutes() {
        return this.getNumberAttribute('password_auto_unlock_minutes');
    }
    /**
     * @stability stable
     */
    set passwordAutoUnlockMinutes(value) {
        this._passwordAutoUnlockMinutes = value;
    }
    /**
     * @stability stable
     */
    resetPasswordAutoUnlockMinutes() {
        this._passwordAutoUnlockMinutes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordAutoUnlockMinutesInput() {
        return this._passwordAutoUnlockMinutes;
    }
    /**
     * @stability stable
     */
    get passwordDictionaryLookup() {
        return this.getBooleanAttribute('password_dictionary_lookup');
    }
    /**
     * @stability stable
     */
    set passwordDictionaryLookup(value) {
        this._passwordDictionaryLookup = value;
    }
    /**
     * @stability stable
     */
    resetPasswordDictionaryLookup() {
        this._passwordDictionaryLookup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordDictionaryLookupInput() {
        return this._passwordDictionaryLookup;
    }
    /**
     * @stability stable
     */
    get passwordExcludeFirstName() {
        return this.getBooleanAttribute('password_exclude_first_name');
    }
    /**
     * @stability stable
     */
    set passwordExcludeFirstName(value) {
        this._passwordExcludeFirstName = value;
    }
    /**
     * @stability stable
     */
    resetPasswordExcludeFirstName() {
        this._passwordExcludeFirstName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordExcludeFirstNameInput() {
        return this._passwordExcludeFirstName;
    }
    /**
     * @stability stable
     */
    get passwordExcludeLastName() {
        return this.getBooleanAttribute('password_exclude_last_name');
    }
    /**
     * @stability stable
     */
    set passwordExcludeLastName(value) {
        this._passwordExcludeLastName = value;
    }
    /**
     * @stability stable
     */
    resetPasswordExcludeLastName() {
        this._passwordExcludeLastName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordExcludeLastNameInput() {
        return this._passwordExcludeLastName;
    }
    /**
     * @stability stable
     */
    get passwordExcludeUsername() {
        return this.getBooleanAttribute('password_exclude_username');
    }
    /**
     * @stability stable
     */
    set passwordExcludeUsername(value) {
        this._passwordExcludeUsername = value;
    }
    /**
     * @stability stable
     */
    resetPasswordExcludeUsername() {
        this._passwordExcludeUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordExcludeUsernameInput() {
        return this._passwordExcludeUsername;
    }
    /**
     * @stability stable
     */
    get passwordExpireWarnDays() {
        return this.getNumberAttribute('password_expire_warn_days');
    }
    /**
     * @stability stable
     */
    set passwordExpireWarnDays(value) {
        this._passwordExpireWarnDays = value;
    }
    /**
     * @stability stable
     */
    resetPasswordExpireWarnDays() {
        this._passwordExpireWarnDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordExpireWarnDaysInput() {
        return this._passwordExpireWarnDays;
    }
    /**
     * @stability stable
     */
    get passwordHistoryCount() {
        return this.getNumberAttribute('password_history_count');
    }
    /**
     * @stability stable
     */
    set passwordHistoryCount(value) {
        this._passwordHistoryCount = value;
    }
    /**
     * @stability stable
     */
    resetPasswordHistoryCount() {
        this._passwordHistoryCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordHistoryCountInput() {
        return this._passwordHistoryCount;
    }
    /**
     * @stability stable
     */
    get passwordLockoutNotificationChannels() {
        return this.getListAttribute('password_lockout_notification_channels');
    }
    /**
     * @stability stable
     */
    set passwordLockoutNotificationChannels(value) {
        this._passwordLockoutNotificationChannels = value;
    }
    /**
     * @stability stable
     */
    resetPasswordLockoutNotificationChannels() {
        this._passwordLockoutNotificationChannels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordLockoutNotificationChannelsInput() {
        return this._passwordLockoutNotificationChannels;
    }
    /**
     * @stability stable
     */
    get passwordMaxAgeDays() {
        return this.getNumberAttribute('password_max_age_days');
    }
    /**
     * @stability stable
     */
    set passwordMaxAgeDays(value) {
        this._passwordMaxAgeDays = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMaxAgeDays() {
        this._passwordMaxAgeDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMaxAgeDaysInput() {
        return this._passwordMaxAgeDays;
    }
    /**
     * @stability stable
     */
    get passwordMaxLockoutAttempts() {
        return this.getNumberAttribute('password_max_lockout_attempts');
    }
    /**
     * @stability stable
     */
    set passwordMaxLockoutAttempts(value) {
        this._passwordMaxLockoutAttempts = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMaxLockoutAttempts() {
        this._passwordMaxLockoutAttempts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMaxLockoutAttemptsInput() {
        return this._passwordMaxLockoutAttempts;
    }
    /**
     * @stability stable
     */
    get passwordMinAgeMinutes() {
        return this.getNumberAttribute('password_min_age_minutes');
    }
    /**
     * @stability stable
     */
    set passwordMinAgeMinutes(value) {
        this._passwordMinAgeMinutes = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMinAgeMinutes() {
        this._passwordMinAgeMinutes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMinAgeMinutesInput() {
        return this._passwordMinAgeMinutes;
    }
    /**
     * @stability stable
     */
    get passwordMinLength() {
        return this.getNumberAttribute('password_min_length');
    }
    /**
     * @stability stable
     */
    set passwordMinLength(value) {
        this._passwordMinLength = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMinLength() {
        this._passwordMinLength = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMinLengthInput() {
        return this._passwordMinLength;
    }
    /**
     * @stability stable
     */
    get passwordMinLowercase() {
        return this.getNumberAttribute('password_min_lowercase');
    }
    /**
     * @stability stable
     */
    set passwordMinLowercase(value) {
        this._passwordMinLowercase = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMinLowercase() {
        this._passwordMinLowercase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMinLowercaseInput() {
        return this._passwordMinLowercase;
    }
    /**
     * @stability stable
     */
    get passwordMinNumber() {
        return this.getNumberAttribute('password_min_number');
    }
    /**
     * @stability stable
     */
    set passwordMinNumber(value) {
        this._passwordMinNumber = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMinNumber() {
        this._passwordMinNumber = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMinNumberInput() {
        return this._passwordMinNumber;
    }
    /**
     * @stability stable
     */
    get passwordMinSymbol() {
        return this.getNumberAttribute('password_min_symbol');
    }
    /**
     * @stability stable
     */
    set passwordMinSymbol(value) {
        this._passwordMinSymbol = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMinSymbol() {
        this._passwordMinSymbol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMinSymbolInput() {
        return this._passwordMinSymbol;
    }
    /**
     * @stability stable
     */
    get passwordMinUppercase() {
        return this.getNumberAttribute('password_min_uppercase');
    }
    /**
     * @stability stable
     */
    set passwordMinUppercase(value) {
        this._passwordMinUppercase = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMinUppercase() {
        this._passwordMinUppercase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMinUppercaseInput() {
        return this._passwordMinUppercase;
    }
    /**
     * @stability stable
     */
    get passwordShowLockoutFailures() {
        return this.getBooleanAttribute('password_show_lockout_failures');
    }
    /**
     * @stability stable
     */
    set passwordShowLockoutFailures(value) {
        this._passwordShowLockoutFailures = value;
    }
    /**
     * @stability stable
     */
    resetPasswordShowLockoutFailures() {
        this._passwordShowLockoutFailures = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordShowLockoutFailuresInput() {
        return this._passwordShowLockoutFailures;
    }
    // priority - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get priority() {
        return this.getNumberAttribute('priority');
    }
    /**
     * @stability stable
     */
    get questionMinLength() {
        return this.getNumberAttribute('question_min_length');
    }
    /**
     * @stability stable
     */
    set questionMinLength(value) {
        this._questionMinLength = value;
    }
    /**
     * @stability stable
     */
    resetQuestionMinLength() {
        this._questionMinLength = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get questionMinLengthInput() {
        return this._questionMinLength;
    }
    /**
     * @stability stable
     */
    get questionRecovery() {
        return this.getStringAttribute('question_recovery');
    }
    /**
     * @stability stable
     */
    set questionRecovery(value) {
        this._questionRecovery = value;
    }
    /**
     * @stability stable
     */
    resetQuestionRecovery() {
        this._questionRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get questionRecoveryInput() {
        return this._questionRecovery;
    }
    /**
     * @stability stable
     */
    get recoveryEmailToken() {
        return this.getNumberAttribute('recovery_email_token');
    }
    /**
     * @stability stable
     */
    set recoveryEmailToken(value) {
        this._recoveryEmailToken = value;
    }
    /**
     * @stability stable
     */
    resetRecoveryEmailToken() {
        this._recoveryEmailToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get recoveryEmailTokenInput() {
        return this._recoveryEmailToken;
    }
    /**
     * @stability stable
     */
    get skipUnlock() {
        return this.getBooleanAttribute('skip_unlock');
    }
    /**
     * @stability stable
     */
    set skipUnlock(value) {
        this._skipUnlock = value;
    }
    /**
     * @stability stable
     */
    resetSkipUnlock() {
        this._skipUnlock = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get skipUnlockInput() {
        return this._skipUnlock;
    }
    /**
     * @stability stable
     */
    get smsRecovery() {
        return this.getStringAttribute('sms_recovery');
    }
    /**
     * @stability stable
     */
    set smsRecovery(value) {
        this._smsRecovery = value;
    }
    /**
     * @stability stable
     */
    resetSmsRecovery() {
        this._smsRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get smsRecoveryInput() {
        return this._smsRecovery;
    }
    // status - computed: true, optional: false, required: false
    /**
     * @stability stable
     */
    get status() {
        return this.getStringAttribute('status');
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     * @stability stable
     */
    synthesizeAttributes() {
        return {
            call_recovery: cdktf.stringToTerraform(this._callRecovery),
            email_recovery: cdktf.stringToTerraform(this._emailRecovery),
            password_auto_unlock_minutes: cdktf.numberToTerraform(this._passwordAutoUnlockMinutes),
            password_dictionary_lookup: cdktf.booleanToTerraform(this._passwordDictionaryLookup),
            password_exclude_first_name: cdktf.booleanToTerraform(this._passwordExcludeFirstName),
            password_exclude_last_name: cdktf.booleanToTerraform(this._passwordExcludeLastName),
            password_exclude_username: cdktf.booleanToTerraform(this._passwordExcludeUsername),
            password_expire_warn_days: cdktf.numberToTerraform(this._passwordExpireWarnDays),
            password_history_count: cdktf.numberToTerraform(this._passwordHistoryCount),
            password_lockout_notification_channels: cdktf.listMapper(cdktf.stringToTerraform)(this._passwordLockoutNotificationChannels),
            password_max_age_days: cdktf.numberToTerraform(this._passwordMaxAgeDays),
            password_max_lockout_attempts: cdktf.numberToTerraform(this._passwordMaxLockoutAttempts),
            password_min_age_minutes: cdktf.numberToTerraform(this._passwordMinAgeMinutes),
            password_min_length: cdktf.numberToTerraform(this._passwordMinLength),
            password_min_lowercase: cdktf.numberToTerraform(this._passwordMinLowercase),
            password_min_number: cdktf.numberToTerraform(this._passwordMinNumber),
            password_min_symbol: cdktf.numberToTerraform(this._passwordMinSymbol),
            password_min_uppercase: cdktf.numberToTerraform(this._passwordMinUppercase),
            password_show_lockout_failures: cdktf.booleanToTerraform(this._passwordShowLockoutFailures),
            question_min_length: cdktf.numberToTerraform(this._questionMinLength),
            question_recovery: cdktf.stringToTerraform(this._questionRecovery),
            recovery_email_token: cdktf.numberToTerraform(this._recoveryEmailToken),
            skip_unlock: cdktf.booleanToTerraform(this._skipUnlock),
            sms_recovery: cdktf.stringToTerraform(this._smsRecovery),
        };
    }
}
exports.PolicyPasswordDefault = PolicyPasswordDefault;
_a = JSII_RTTI_SYMBOL_1;
PolicyPasswordDefault[_a] = { fqn: "@cdktf/provider-okta.PolicyPasswordDefault", version: "0.0.52" };
// =================
// STATIC PROPERTIES
// =================
/**
 * @stability stable
 */
PolicyPasswordDefault.tfResourceType = "okta_policy_password_default";
//# sourceMappingURL=data:application/json;base64,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