import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PolicyPasswordConfig extends cdktf.TerraformMetaArguments {
    /**
     * Authentication Provider: OKTA or ACTIVE_DIRECTORY.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#auth_provider PolicyPassword#auth_provider}
     *
     * @stability stable
     */
    readonly authProvider?: string;
    /**
     * Enable or disable voice call recovery: ACTIVE or INACTIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#call_recovery PolicyPassword#call_recovery}
     *
     * @stability stable
     */
    readonly callRecovery?: string;
    /**
     * Policy Description.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#description PolicyPassword#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Enable or disable email password recovery: ACTIVE or INACTIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#email_recovery PolicyPassword#email_recovery}
     *
     * @stability stable
     */
    readonly emailRecovery?: string;
    /**
     * List of Group IDs to Include.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#groups_included PolicyPassword#groups_included}
     *
     * @stability stable
     */
    readonly groupsIncluded?: string[];
    /**
     * Policy Name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#name PolicyPassword#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Number of minutes before a locked account is unlocked: 0 = no limit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_auto_unlock_minutes PolicyPassword#password_auto_unlock_minutes}
     *
     * @stability stable
     */
    readonly passwordAutoUnlockMinutes?: number;
    /**
     * Check Passwords Against Common Password Dictionary.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_dictionary_lookup PolicyPassword#password_dictionary_lookup}
     *
     * @stability stable
     */
    readonly passwordDictionaryLookup?: boolean | cdktf.IResolvable;
    /**
     * User firstName attribute must be excluded from the password.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_exclude_first_name PolicyPassword#password_exclude_first_name}
     *
     * @stability stable
     */
    readonly passwordExcludeFirstName?: boolean | cdktf.IResolvable;
    /**
     * User lastName attribute must be excluded from the password.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_exclude_last_name PolicyPassword#password_exclude_last_name}
     *
     * @stability stable
     */
    readonly passwordExcludeLastName?: boolean | cdktf.IResolvable;
    /**
     * If the user name must be excluded from the password.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_exclude_username PolicyPassword#password_exclude_username}
     *
     * @stability stable
     */
    readonly passwordExcludeUsername?: boolean | cdktf.IResolvable;
    /**
     * Length in days a user will be warned before password expiry: 0 = no warning.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_expire_warn_days PolicyPassword#password_expire_warn_days}
     *
     * @stability stable
     */
    readonly passwordExpireWarnDays?: number;
    /**
     * Number of distinct passwords that must be created before they can be reused: 0 = none.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_history_count PolicyPassword#password_history_count}
     *
     * @stability stable
     */
    readonly passwordHistoryCount?: number;
    /**
     * Notification channels to use to notify a user when their account has been locked.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_lockout_notification_channels PolicyPassword#password_lockout_notification_channels}
     *
     * @stability stable
     */
    readonly passwordLockoutNotificationChannels?: string[];
    /**
     * Length in days a password is valid before expiry: 0 = no limit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_max_age_days PolicyPassword#password_max_age_days}
     *
     * @stability stable
     */
    readonly passwordMaxAgeDays?: number;
    /**
     * Number of unsuccessful login attempts allowed before lockout: 0 = no limit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_max_lockout_attempts PolicyPassword#password_max_lockout_attempts}
     *
     * @stability stable
     */
    readonly passwordMaxLockoutAttempts?: number;
    /**
     * Minimum time interval in minutes between password changes: 0 = no limit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_min_age_minutes PolicyPassword#password_min_age_minutes}
     *
     * @stability stable
     */
    readonly passwordMinAgeMinutes?: number;
    /**
     * Minimum password length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_min_length PolicyPassword#password_min_length}
     *
     * @stability stable
     */
    readonly passwordMinLength?: number;
    /**
     * If a password must contain at least one lower case letter: 0 = no, 1 = yes.
     *
     * Default = 1
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_min_lowercase PolicyPassword#password_min_lowercase}
     *
     * @stability stable
     */
    readonly passwordMinLowercase?: number;
    /**
     * If a password must contain at least one number: 0 = no, 1 = yes. Default = 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_min_number PolicyPassword#password_min_number}
     *
     * @stability stable
     */
    readonly passwordMinNumber?: number;
    /**
     * If a password must contain at least one symbol (!@#$%^&*): 0 = no, 1 = yes. Default = 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_min_symbol PolicyPassword#password_min_symbol}
     *
     * @stability stable
     */
    readonly passwordMinSymbol?: number;
    /**
     * If a password must contain at least one upper case letter: 0 = no, 1 = yes.
     *
     * Default = 1
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_min_uppercase PolicyPassword#password_min_uppercase}
     *
     * @stability stable
     */
    readonly passwordMinUppercase?: number;
    /**
     * If a user should be informed when their account is locked.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#password_show_lockout_failures PolicyPassword#password_show_lockout_failures}
     *
     * @stability stable
     */
    readonly passwordShowLockoutFailures?: boolean | cdktf.IResolvable;
    /**
     * Policy Priority, this attribute can be set to a valid priority.
     *
     * To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#priority PolicyPassword#priority}
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Min length of the password recovery question answer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#question_min_length PolicyPassword#question_min_length}
     *
     * @stability stable
     */
    readonly questionMinLength?: number;
    /**
     * Enable or disable security question password recovery: ACTIVE or INACTIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#question_recovery PolicyPassword#question_recovery}
     *
     * @stability stable
     */
    readonly questionRecovery?: string;
    /**
     * Lifetime in minutes of the recovery email token.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#recovery_email_token PolicyPassword#recovery_email_token}
     *
     * @stability stable
     */
    readonly recoveryEmailToken?: number;
    /**
     * When an Active Directory user is locked out of Okta, the Okta unlock operation should also attempt to unlock the user's Windows account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#skip_unlock PolicyPassword#skip_unlock}
     *
     * @stability stable
     */
    readonly skipUnlock?: boolean | cdktf.IResolvable;
    /**
     * Enable or disable SMS password recovery: ACTIVE or INACTIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#sms_recovery PolicyPassword#sms_recovery}
     *
     * @stability stable
     */
    readonly smsRecovery?: string;
    /**
     * Policy Status: ACTIVE or INACTIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html#status PolicyPassword#status}
     *
     * @stability stable
     */
    readonly status?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html okta_policy_password}.
 *
 * @stability stable
 */
export declare class PolicyPassword extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html okta_policy_password} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PolicyPasswordConfig);
    private _authProvider?;
    /**
     * @stability stable
     */
    get authProvider(): string;
    /**
     * @stability stable
     */
    set authProvider(value: string);
    /**
     * @stability stable
     */
    resetAuthProvider(): void;
    /**
     * @stability stable
     */
    get authProviderInput(): string | undefined;
    private _callRecovery?;
    /**
     * @stability stable
     */
    get callRecovery(): string;
    /**
     * @stability stable
     */
    set callRecovery(value: string);
    /**
     * @stability stable
     */
    resetCallRecovery(): void;
    /**
     * @stability stable
     */
    get callRecoveryInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _emailRecovery?;
    /**
     * @stability stable
     */
    get emailRecovery(): string;
    /**
     * @stability stable
     */
    set emailRecovery(value: string);
    /**
     * @stability stable
     */
    resetEmailRecovery(): void;
    /**
     * @stability stable
     */
    get emailRecoveryInput(): string | undefined;
    private _groupsIncluded?;
    /**
     * @stability stable
     */
    get groupsIncluded(): string[];
    /**
     * @stability stable
     */
    set groupsIncluded(value: string[]);
    /**
     * @stability stable
     */
    resetGroupsIncluded(): void;
    /**
     * @stability stable
     */
    get groupsIncludedInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _passwordAutoUnlockMinutes?;
    /**
     * @stability stable
     */
    get passwordAutoUnlockMinutes(): number;
    /**
     * @stability stable
     */
    set passwordAutoUnlockMinutes(value: number);
    /**
     * @stability stable
     */
    resetPasswordAutoUnlockMinutes(): void;
    /**
     * @stability stable
     */
    get passwordAutoUnlockMinutesInput(): number | undefined;
    private _passwordDictionaryLookup?;
    /**
     * @stability stable
     */
    get passwordDictionaryLookup(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set passwordDictionaryLookup(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPasswordDictionaryLookup(): void;
    /**
     * @stability stable
     */
    get passwordDictionaryLookupInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordExcludeFirstName?;
    /**
     * @stability stable
     */
    get passwordExcludeFirstName(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set passwordExcludeFirstName(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPasswordExcludeFirstName(): void;
    /**
     * @stability stable
     */
    get passwordExcludeFirstNameInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordExcludeLastName?;
    /**
     * @stability stable
     */
    get passwordExcludeLastName(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set passwordExcludeLastName(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPasswordExcludeLastName(): void;
    /**
     * @stability stable
     */
    get passwordExcludeLastNameInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordExcludeUsername?;
    /**
     * @stability stable
     */
    get passwordExcludeUsername(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set passwordExcludeUsername(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPasswordExcludeUsername(): void;
    /**
     * @stability stable
     */
    get passwordExcludeUsernameInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordExpireWarnDays?;
    /**
     * @stability stable
     */
    get passwordExpireWarnDays(): number;
    /**
     * @stability stable
     */
    set passwordExpireWarnDays(value: number);
    /**
     * @stability stable
     */
    resetPasswordExpireWarnDays(): void;
    /**
     * @stability stable
     */
    get passwordExpireWarnDaysInput(): number | undefined;
    private _passwordHistoryCount?;
    /**
     * @stability stable
     */
    get passwordHistoryCount(): number;
    /**
     * @stability stable
     */
    set passwordHistoryCount(value: number);
    /**
     * @stability stable
     */
    resetPasswordHistoryCount(): void;
    /**
     * @stability stable
     */
    get passwordHistoryCountInput(): number | undefined;
    private _passwordLockoutNotificationChannels?;
    /**
     * @stability stable
     */
    get passwordLockoutNotificationChannels(): string[];
    /**
     * @stability stable
     */
    set passwordLockoutNotificationChannels(value: string[]);
    /**
     * @stability stable
     */
    resetPasswordLockoutNotificationChannels(): void;
    /**
     * @stability stable
     */
    get passwordLockoutNotificationChannelsInput(): string[] | undefined;
    private _passwordMaxAgeDays?;
    /**
     * @stability stable
     */
    get passwordMaxAgeDays(): number;
    /**
     * @stability stable
     */
    set passwordMaxAgeDays(value: number);
    /**
     * @stability stable
     */
    resetPasswordMaxAgeDays(): void;
    /**
     * @stability stable
     */
    get passwordMaxAgeDaysInput(): number | undefined;
    private _passwordMaxLockoutAttempts?;
    /**
     * @stability stable
     */
    get passwordMaxLockoutAttempts(): number;
    /**
     * @stability stable
     */
    set passwordMaxLockoutAttempts(value: number);
    /**
     * @stability stable
     */
    resetPasswordMaxLockoutAttempts(): void;
    /**
     * @stability stable
     */
    get passwordMaxLockoutAttemptsInput(): number | undefined;
    private _passwordMinAgeMinutes?;
    /**
     * @stability stable
     */
    get passwordMinAgeMinutes(): number;
    /**
     * @stability stable
     */
    set passwordMinAgeMinutes(value: number);
    /**
     * @stability stable
     */
    resetPasswordMinAgeMinutes(): void;
    /**
     * @stability stable
     */
    get passwordMinAgeMinutesInput(): number | undefined;
    private _passwordMinLength?;
    /**
     * @stability stable
     */
    get passwordMinLength(): number;
    /**
     * @stability stable
     */
    set passwordMinLength(value: number);
    /**
     * @stability stable
     */
    resetPasswordMinLength(): void;
    /**
     * @stability stable
     */
    get passwordMinLengthInput(): number | undefined;
    private _passwordMinLowercase?;
    /**
     * @stability stable
     */
    get passwordMinLowercase(): number;
    /**
     * @stability stable
     */
    set passwordMinLowercase(value: number);
    /**
     * @stability stable
     */
    resetPasswordMinLowercase(): void;
    /**
     * @stability stable
     */
    get passwordMinLowercaseInput(): number | undefined;
    private _passwordMinNumber?;
    /**
     * @stability stable
     */
    get passwordMinNumber(): number;
    /**
     * @stability stable
     */
    set passwordMinNumber(value: number);
    /**
     * @stability stable
     */
    resetPasswordMinNumber(): void;
    /**
     * @stability stable
     */
    get passwordMinNumberInput(): number | undefined;
    private _passwordMinSymbol?;
    /**
     * @stability stable
     */
    get passwordMinSymbol(): number;
    /**
     * @stability stable
     */
    set passwordMinSymbol(value: number);
    /**
     * @stability stable
     */
    resetPasswordMinSymbol(): void;
    /**
     * @stability stable
     */
    get passwordMinSymbolInput(): number | undefined;
    private _passwordMinUppercase?;
    /**
     * @stability stable
     */
    get passwordMinUppercase(): number;
    /**
     * @stability stable
     */
    set passwordMinUppercase(value: number);
    /**
     * @stability stable
     */
    resetPasswordMinUppercase(): void;
    /**
     * @stability stable
     */
    get passwordMinUppercaseInput(): number | undefined;
    private _passwordShowLockoutFailures?;
    /**
     * @stability stable
     */
    get passwordShowLockoutFailures(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set passwordShowLockoutFailures(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPasswordShowLockoutFailures(): void;
    /**
     * @stability stable
     */
    get passwordShowLockoutFailuresInput(): boolean | cdktf.IResolvable | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _questionMinLength?;
    /**
     * @stability stable
     */
    get questionMinLength(): number;
    /**
     * @stability stable
     */
    set questionMinLength(value: number);
    /**
     * @stability stable
     */
    resetQuestionMinLength(): void;
    /**
     * @stability stable
     */
    get questionMinLengthInput(): number | undefined;
    private _questionRecovery?;
    /**
     * @stability stable
     */
    get questionRecovery(): string;
    /**
     * @stability stable
     */
    set questionRecovery(value: string);
    /**
     * @stability stable
     */
    resetQuestionRecovery(): void;
    /**
     * @stability stable
     */
    get questionRecoveryInput(): string | undefined;
    private _recoveryEmailToken?;
    /**
     * @stability stable
     */
    get recoveryEmailToken(): number;
    /**
     * @stability stable
     */
    set recoveryEmailToken(value: number);
    /**
     * @stability stable
     */
    resetRecoveryEmailToken(): void;
    /**
     * @stability stable
     */
    get recoveryEmailTokenInput(): number | undefined;
    private _skipUnlock?;
    /**
     * @stability stable
     */
    get skipUnlock(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipUnlock(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipUnlock(): void;
    /**
     * @stability stable
     */
    get skipUnlockInput(): boolean | cdktf.IResolvable | undefined;
    private _smsRecovery?;
    /**
     * @stability stable
     */
    get smsRecovery(): string;
    /**
     * @stability stable
     */
    set smsRecovery(value: string);
    /**
     * @stability stable
     */
    resetSmsRecovery(): void;
    /**
     * @stability stable
     */
    get smsRecoveryInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
