"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyPassword = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html okta_policy_password}.
 *
 * @stability stable
 */
class PolicyPassword extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_password.html okta_policy_password} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'okta_policy_password',
            terraformGeneratorMetadata: {
                providerName: 'okta'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._authProvider = config.authProvider;
        this._callRecovery = config.callRecovery;
        this._description = config.description;
        this._emailRecovery = config.emailRecovery;
        this._groupsIncluded = config.groupsIncluded;
        this._name = config.name;
        this._passwordAutoUnlockMinutes = config.passwordAutoUnlockMinutes;
        this._passwordDictionaryLookup = config.passwordDictionaryLookup;
        this._passwordExcludeFirstName = config.passwordExcludeFirstName;
        this._passwordExcludeLastName = config.passwordExcludeLastName;
        this._passwordExcludeUsername = config.passwordExcludeUsername;
        this._passwordExpireWarnDays = config.passwordExpireWarnDays;
        this._passwordHistoryCount = config.passwordHistoryCount;
        this._passwordLockoutNotificationChannels = config.passwordLockoutNotificationChannels;
        this._passwordMaxAgeDays = config.passwordMaxAgeDays;
        this._passwordMaxLockoutAttempts = config.passwordMaxLockoutAttempts;
        this._passwordMinAgeMinutes = config.passwordMinAgeMinutes;
        this._passwordMinLength = config.passwordMinLength;
        this._passwordMinLowercase = config.passwordMinLowercase;
        this._passwordMinNumber = config.passwordMinNumber;
        this._passwordMinSymbol = config.passwordMinSymbol;
        this._passwordMinUppercase = config.passwordMinUppercase;
        this._passwordShowLockoutFailures = config.passwordShowLockoutFailures;
        this._priority = config.priority;
        this._questionMinLength = config.questionMinLength;
        this._questionRecovery = config.questionRecovery;
        this._recoveryEmailToken = config.recoveryEmailToken;
        this._skipUnlock = config.skipUnlock;
        this._smsRecovery = config.smsRecovery;
        this._status = config.status;
    }
    /**
     * @stability stable
     */
    get authProvider() {
        return this.getStringAttribute('auth_provider');
    }
    /**
     * @stability stable
     */
    set authProvider(value) {
        this._authProvider = value;
    }
    /**
     * @stability stable
     */
    resetAuthProvider() {
        this._authProvider = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get authProviderInput() {
        return this._authProvider;
    }
    /**
     * @stability stable
     */
    get callRecovery() {
        return this.getStringAttribute('call_recovery');
    }
    /**
     * @stability stable
     */
    set callRecovery(value) {
        this._callRecovery = value;
    }
    /**
     * @stability stable
     */
    resetCallRecovery() {
        this._callRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get callRecoveryInput() {
        return this._callRecovery;
    }
    /**
     * @stability stable
     */
    get description() {
        return this.getStringAttribute('description');
    }
    /**
     * @stability stable
     */
    set description(value) {
        this._description = value;
    }
    /**
     * @stability stable
     */
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get descriptionInput() {
        return this._description;
    }
    /**
     * @stability stable
     */
    get emailRecovery() {
        return this.getStringAttribute('email_recovery');
    }
    /**
     * @stability stable
     */
    set emailRecovery(value) {
        this._emailRecovery = value;
    }
    /**
     * @stability stable
     */
    resetEmailRecovery() {
        this._emailRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get emailRecoveryInput() {
        return this._emailRecovery;
    }
    /**
     * @stability stable
     */
    get groupsIncluded() {
        return this.getListAttribute('groups_included');
    }
    /**
     * @stability stable
     */
    set groupsIncluded(value) {
        this._groupsIncluded = value;
    }
    /**
     * @stability stable
     */
    resetGroupsIncluded() {
        this._groupsIncluded = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get groupsIncludedInput() {
        return this._groupsIncluded;
    }
    // id - computed: true, optional: true, required: false
    /**
     * @stability stable
     */
    get id() {
        return this.getStringAttribute('id');
    }
    /**
     * @stability stable
     */
    get name() {
        return this.getStringAttribute('name');
    }
    /**
     * @stability stable
     */
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get nameInput() {
        return this._name;
    }
    /**
     * @stability stable
     */
    get passwordAutoUnlockMinutes() {
        return this.getNumberAttribute('password_auto_unlock_minutes');
    }
    /**
     * @stability stable
     */
    set passwordAutoUnlockMinutes(value) {
        this._passwordAutoUnlockMinutes = value;
    }
    /**
     * @stability stable
     */
    resetPasswordAutoUnlockMinutes() {
        this._passwordAutoUnlockMinutes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordAutoUnlockMinutesInput() {
        return this._passwordAutoUnlockMinutes;
    }
    /**
     * @stability stable
     */
    get passwordDictionaryLookup() {
        return this.getBooleanAttribute('password_dictionary_lookup');
    }
    /**
     * @stability stable
     */
    set passwordDictionaryLookup(value) {
        this._passwordDictionaryLookup = value;
    }
    /**
     * @stability stable
     */
    resetPasswordDictionaryLookup() {
        this._passwordDictionaryLookup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordDictionaryLookupInput() {
        return this._passwordDictionaryLookup;
    }
    /**
     * @stability stable
     */
    get passwordExcludeFirstName() {
        return this.getBooleanAttribute('password_exclude_first_name');
    }
    /**
     * @stability stable
     */
    set passwordExcludeFirstName(value) {
        this._passwordExcludeFirstName = value;
    }
    /**
     * @stability stable
     */
    resetPasswordExcludeFirstName() {
        this._passwordExcludeFirstName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordExcludeFirstNameInput() {
        return this._passwordExcludeFirstName;
    }
    /**
     * @stability stable
     */
    get passwordExcludeLastName() {
        return this.getBooleanAttribute('password_exclude_last_name');
    }
    /**
     * @stability stable
     */
    set passwordExcludeLastName(value) {
        this._passwordExcludeLastName = value;
    }
    /**
     * @stability stable
     */
    resetPasswordExcludeLastName() {
        this._passwordExcludeLastName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordExcludeLastNameInput() {
        return this._passwordExcludeLastName;
    }
    /**
     * @stability stable
     */
    get passwordExcludeUsername() {
        return this.getBooleanAttribute('password_exclude_username');
    }
    /**
     * @stability stable
     */
    set passwordExcludeUsername(value) {
        this._passwordExcludeUsername = value;
    }
    /**
     * @stability stable
     */
    resetPasswordExcludeUsername() {
        this._passwordExcludeUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordExcludeUsernameInput() {
        return this._passwordExcludeUsername;
    }
    /**
     * @stability stable
     */
    get passwordExpireWarnDays() {
        return this.getNumberAttribute('password_expire_warn_days');
    }
    /**
     * @stability stable
     */
    set passwordExpireWarnDays(value) {
        this._passwordExpireWarnDays = value;
    }
    /**
     * @stability stable
     */
    resetPasswordExpireWarnDays() {
        this._passwordExpireWarnDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordExpireWarnDaysInput() {
        return this._passwordExpireWarnDays;
    }
    /**
     * @stability stable
     */
    get passwordHistoryCount() {
        return this.getNumberAttribute('password_history_count');
    }
    /**
     * @stability stable
     */
    set passwordHistoryCount(value) {
        this._passwordHistoryCount = value;
    }
    /**
     * @stability stable
     */
    resetPasswordHistoryCount() {
        this._passwordHistoryCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordHistoryCountInput() {
        return this._passwordHistoryCount;
    }
    /**
     * @stability stable
     */
    get passwordLockoutNotificationChannels() {
        return this.getListAttribute('password_lockout_notification_channels');
    }
    /**
     * @stability stable
     */
    set passwordLockoutNotificationChannels(value) {
        this._passwordLockoutNotificationChannels = value;
    }
    /**
     * @stability stable
     */
    resetPasswordLockoutNotificationChannels() {
        this._passwordLockoutNotificationChannels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordLockoutNotificationChannelsInput() {
        return this._passwordLockoutNotificationChannels;
    }
    /**
     * @stability stable
     */
    get passwordMaxAgeDays() {
        return this.getNumberAttribute('password_max_age_days');
    }
    /**
     * @stability stable
     */
    set passwordMaxAgeDays(value) {
        this._passwordMaxAgeDays = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMaxAgeDays() {
        this._passwordMaxAgeDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMaxAgeDaysInput() {
        return this._passwordMaxAgeDays;
    }
    /**
     * @stability stable
     */
    get passwordMaxLockoutAttempts() {
        return this.getNumberAttribute('password_max_lockout_attempts');
    }
    /**
     * @stability stable
     */
    set passwordMaxLockoutAttempts(value) {
        this._passwordMaxLockoutAttempts = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMaxLockoutAttempts() {
        this._passwordMaxLockoutAttempts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMaxLockoutAttemptsInput() {
        return this._passwordMaxLockoutAttempts;
    }
    /**
     * @stability stable
     */
    get passwordMinAgeMinutes() {
        return this.getNumberAttribute('password_min_age_minutes');
    }
    /**
     * @stability stable
     */
    set passwordMinAgeMinutes(value) {
        this._passwordMinAgeMinutes = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMinAgeMinutes() {
        this._passwordMinAgeMinutes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMinAgeMinutesInput() {
        return this._passwordMinAgeMinutes;
    }
    /**
     * @stability stable
     */
    get passwordMinLength() {
        return this.getNumberAttribute('password_min_length');
    }
    /**
     * @stability stable
     */
    set passwordMinLength(value) {
        this._passwordMinLength = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMinLength() {
        this._passwordMinLength = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMinLengthInput() {
        return this._passwordMinLength;
    }
    /**
     * @stability stable
     */
    get passwordMinLowercase() {
        return this.getNumberAttribute('password_min_lowercase');
    }
    /**
     * @stability stable
     */
    set passwordMinLowercase(value) {
        this._passwordMinLowercase = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMinLowercase() {
        this._passwordMinLowercase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMinLowercaseInput() {
        return this._passwordMinLowercase;
    }
    /**
     * @stability stable
     */
    get passwordMinNumber() {
        return this.getNumberAttribute('password_min_number');
    }
    /**
     * @stability stable
     */
    set passwordMinNumber(value) {
        this._passwordMinNumber = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMinNumber() {
        this._passwordMinNumber = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMinNumberInput() {
        return this._passwordMinNumber;
    }
    /**
     * @stability stable
     */
    get passwordMinSymbol() {
        return this.getNumberAttribute('password_min_symbol');
    }
    /**
     * @stability stable
     */
    set passwordMinSymbol(value) {
        this._passwordMinSymbol = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMinSymbol() {
        this._passwordMinSymbol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMinSymbolInput() {
        return this._passwordMinSymbol;
    }
    /**
     * @stability stable
     */
    get passwordMinUppercase() {
        return this.getNumberAttribute('password_min_uppercase');
    }
    /**
     * @stability stable
     */
    set passwordMinUppercase(value) {
        this._passwordMinUppercase = value;
    }
    /**
     * @stability stable
     */
    resetPasswordMinUppercase() {
        this._passwordMinUppercase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordMinUppercaseInput() {
        return this._passwordMinUppercase;
    }
    /**
     * @stability stable
     */
    get passwordShowLockoutFailures() {
        return this.getBooleanAttribute('password_show_lockout_failures');
    }
    /**
     * @stability stable
     */
    set passwordShowLockoutFailures(value) {
        this._passwordShowLockoutFailures = value;
    }
    /**
     * @stability stable
     */
    resetPasswordShowLockoutFailures() {
        this._passwordShowLockoutFailures = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get passwordShowLockoutFailuresInput() {
        return this._passwordShowLockoutFailures;
    }
    /**
     * @stability stable
     */
    get priority() {
        return this.getNumberAttribute('priority');
    }
    /**
     * @stability stable
     */
    set priority(value) {
        this._priority = value;
    }
    /**
     * @stability stable
     */
    resetPriority() {
        this._priority = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get priorityInput() {
        return this._priority;
    }
    /**
     * @stability stable
     */
    get questionMinLength() {
        return this.getNumberAttribute('question_min_length');
    }
    /**
     * @stability stable
     */
    set questionMinLength(value) {
        this._questionMinLength = value;
    }
    /**
     * @stability stable
     */
    resetQuestionMinLength() {
        this._questionMinLength = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get questionMinLengthInput() {
        return this._questionMinLength;
    }
    /**
     * @stability stable
     */
    get questionRecovery() {
        return this.getStringAttribute('question_recovery');
    }
    /**
     * @stability stable
     */
    set questionRecovery(value) {
        this._questionRecovery = value;
    }
    /**
     * @stability stable
     */
    resetQuestionRecovery() {
        this._questionRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get questionRecoveryInput() {
        return this._questionRecovery;
    }
    /**
     * @stability stable
     */
    get recoveryEmailToken() {
        return this.getNumberAttribute('recovery_email_token');
    }
    /**
     * @stability stable
     */
    set recoveryEmailToken(value) {
        this._recoveryEmailToken = value;
    }
    /**
     * @stability stable
     */
    resetRecoveryEmailToken() {
        this._recoveryEmailToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get recoveryEmailTokenInput() {
        return this._recoveryEmailToken;
    }
    /**
     * @stability stable
     */
    get skipUnlock() {
        return this.getBooleanAttribute('skip_unlock');
    }
    /**
     * @stability stable
     */
    set skipUnlock(value) {
        this._skipUnlock = value;
    }
    /**
     * @stability stable
     */
    resetSkipUnlock() {
        this._skipUnlock = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get skipUnlockInput() {
        return this._skipUnlock;
    }
    /**
     * @stability stable
     */
    get smsRecovery() {
        return this.getStringAttribute('sms_recovery');
    }
    /**
     * @stability stable
     */
    set smsRecovery(value) {
        this._smsRecovery = value;
    }
    /**
     * @stability stable
     */
    resetSmsRecovery() {
        this._smsRecovery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get smsRecoveryInput() {
        return this._smsRecovery;
    }
    /**
     * @stability stable
     */
    get status() {
        return this.getStringAttribute('status');
    }
    /**
     * @stability stable
     */
    set status(value) {
        this._status = value;
    }
    /**
     * @stability stable
     */
    resetStatus() {
        this._status = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get statusInput() {
        return this._status;
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     * @stability stable
     */
    synthesizeAttributes() {
        return {
            auth_provider: cdktf.stringToTerraform(this._authProvider),
            call_recovery: cdktf.stringToTerraform(this._callRecovery),
            description: cdktf.stringToTerraform(this._description),
            email_recovery: cdktf.stringToTerraform(this._emailRecovery),
            groups_included: cdktf.listMapper(cdktf.stringToTerraform)(this._groupsIncluded),
            name: cdktf.stringToTerraform(this._name),
            password_auto_unlock_minutes: cdktf.numberToTerraform(this._passwordAutoUnlockMinutes),
            password_dictionary_lookup: cdktf.booleanToTerraform(this._passwordDictionaryLookup),
            password_exclude_first_name: cdktf.booleanToTerraform(this._passwordExcludeFirstName),
            password_exclude_last_name: cdktf.booleanToTerraform(this._passwordExcludeLastName),
            password_exclude_username: cdktf.booleanToTerraform(this._passwordExcludeUsername),
            password_expire_warn_days: cdktf.numberToTerraform(this._passwordExpireWarnDays),
            password_history_count: cdktf.numberToTerraform(this._passwordHistoryCount),
            password_lockout_notification_channels: cdktf.listMapper(cdktf.stringToTerraform)(this._passwordLockoutNotificationChannels),
            password_max_age_days: cdktf.numberToTerraform(this._passwordMaxAgeDays),
            password_max_lockout_attempts: cdktf.numberToTerraform(this._passwordMaxLockoutAttempts),
            password_min_age_minutes: cdktf.numberToTerraform(this._passwordMinAgeMinutes),
            password_min_length: cdktf.numberToTerraform(this._passwordMinLength),
            password_min_lowercase: cdktf.numberToTerraform(this._passwordMinLowercase),
            password_min_number: cdktf.numberToTerraform(this._passwordMinNumber),
            password_min_symbol: cdktf.numberToTerraform(this._passwordMinSymbol),
            password_min_uppercase: cdktf.numberToTerraform(this._passwordMinUppercase),
            password_show_lockout_failures: cdktf.booleanToTerraform(this._passwordShowLockoutFailures),
            priority: cdktf.numberToTerraform(this._priority),
            question_min_length: cdktf.numberToTerraform(this._questionMinLength),
            question_recovery: cdktf.stringToTerraform(this._questionRecovery),
            recovery_email_token: cdktf.numberToTerraform(this._recoveryEmailToken),
            skip_unlock: cdktf.booleanToTerraform(this._skipUnlock),
            sms_recovery: cdktf.stringToTerraform(this._smsRecovery),
            status: cdktf.stringToTerraform(this._status),
        };
    }
}
exports.PolicyPassword = PolicyPassword;
_a = JSII_RTTI_SYMBOL_1;
PolicyPassword[_a] = { fqn: "@cdktf/provider-okta.PolicyPassword", version: "0.0.52" };
// =================
// STATIC PROPERTIES
// =================
/**
 * @stability stable
 */
PolicyPassword.tfResourceType = "okta_policy_password";
//# sourceMappingURL=data:application/json;base64,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