import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PolicyProfileEnrollmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_profile_enrollment.html#name PolicyProfileEnrollment#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Status of the policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_profile_enrollment.html#status PolicyProfileEnrollment#status}
     *
     * @stability stable
     */
    readonly status?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_profile_enrollment.html okta_policy_profile_enrollment}.
 *
 * @stability stable
 */
export declare class PolicyProfileEnrollment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_profile_enrollment.html okta_policy_profile_enrollment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PolicyProfileEnrollmentConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
