import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PolicyRuleIdpDiscoveryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#idp_id PolicyRuleIdpDiscovery#idp_id}.
     *
     * @stability stable
     */
    readonly idpId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#idp_type PolicyRuleIdpDiscovery#idp_type}.
     *
     * @stability stable
     */
    readonly idpType?: string;
    /**
     * Policy Rule Name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#name PolicyRuleIdpDiscovery#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#network_connection PolicyRuleIdpDiscovery#network_connection}
     *
     * @stability stable
     */
    readonly networkConnection?: string;
    /**
     * The zones to exclude.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#network_excludes PolicyRuleIdpDiscovery#network_excludes}
     *
     * @stability stable
     */
    readonly networkExcludes?: string[];
    /**
     * The zones to include.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#network_includes PolicyRuleIdpDiscovery#network_includes}
     *
     * @stability stable
     */
    readonly networkIncludes?: string[];
    /**
     * Policy ID of the Rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#policy_id PolicyRuleIdpDiscovery#policy_id}
     *
     * @stability stable
     */
    readonly policyId?: string;
    /**
     * Policy ID of the Rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#policyid PolicyRuleIdpDiscovery#policyid}
     *
     * @stability stable
     */
    readonly policyid?: string;
    /**
     * Policy Rule Priority, this attribute can be set to a valid priority.
     *
     * To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#priority PolicyRuleIdpDiscovery#priority}
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Policy Rule Status: ACTIVE or INACTIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#status PolicyRuleIdpDiscovery#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#user_identifier_attribute PolicyRuleIdpDiscovery#user_identifier_attribute}.
     *
     * @stability stable
     */
    readonly userIdentifierAttribute?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#user_identifier_type PolicyRuleIdpDiscovery#user_identifier_type}.
     *
     * @stability stable
     */
    readonly userIdentifierType?: string;
    /**
     * app_exclude block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#app_exclude PolicyRuleIdpDiscovery#app_exclude}
     *
     * @stability stable
     */
    readonly appExclude?: PolicyRuleIdpDiscoveryAppExclude[];
    /**
     * app_include block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#app_include PolicyRuleIdpDiscovery#app_include}
     *
     * @stability stable
     */
    readonly appInclude?: PolicyRuleIdpDiscoveryAppInclude[];
    /**
     * platform_include block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#platform_include PolicyRuleIdpDiscovery#platform_include}
     *
     * @stability stable
     */
    readonly platformInclude?: PolicyRuleIdpDiscoveryPlatformInclude[];
    /**
     * user_identifier_patterns block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#user_identifier_patterns PolicyRuleIdpDiscovery#user_identifier_patterns}
     *
     * @stability stable
     */
    readonly userIdentifierPatterns?: PolicyRuleIdpDiscoveryUserIdentifierPatterns[];
}
/**
 * @stability stable
 */
export interface PolicyRuleIdpDiscoveryAppExclude {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#id PolicyRuleIdpDiscovery#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#name PolicyRuleIdpDiscovery#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#type PolicyRuleIdpDiscovery#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function policyRuleIdpDiscoveryAppExcludeToTerraform(struct?: PolicyRuleIdpDiscoveryAppExclude): any;
/**
 * @stability stable
 */
export interface PolicyRuleIdpDiscoveryAppInclude {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#id PolicyRuleIdpDiscovery#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#name PolicyRuleIdpDiscovery#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#type PolicyRuleIdpDiscovery#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function policyRuleIdpDiscoveryAppIncludeToTerraform(struct?: PolicyRuleIdpDiscoveryAppInclude): any;
/**
 * @stability stable
 */
export interface PolicyRuleIdpDiscoveryPlatformInclude {
    /**
     * Only available with OTHER OS type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#os_expression PolicyRuleIdpDiscovery#os_expression}
     *
     * @stability stable
     */
    readonly osExpression?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#os_type PolicyRuleIdpDiscovery#os_type}.
     *
     * @stability stable
     */
    readonly osType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#type PolicyRuleIdpDiscovery#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function policyRuleIdpDiscoveryPlatformIncludeToTerraform(struct?: PolicyRuleIdpDiscoveryPlatformInclude): any;
/**
 * @stability stable
 */
export interface PolicyRuleIdpDiscoveryUserIdentifierPatterns {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#match_type PolicyRuleIdpDiscovery#match_type}.
     *
     * @stability stable
     */
    readonly matchType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html#value PolicyRuleIdpDiscovery#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function policyRuleIdpDiscoveryUserIdentifierPatternsToTerraform(struct?: PolicyRuleIdpDiscoveryUserIdentifierPatterns): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html okta_policy_rule_idp_discovery}.
 *
 * @stability stable
 */
export declare class PolicyRuleIdpDiscovery extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_idp_discovery.html okta_policy_rule_idp_discovery} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PolicyRuleIdpDiscoveryConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _idpId?;
    /**
     * @stability stable
     */
    get idpId(): string;
    /**
     * @stability stable
     */
    set idpId(value: string);
    /**
     * @stability stable
     */
    resetIdpId(): void;
    /**
     * @stability stable
     */
    get idpIdInput(): string | undefined;
    private _idpType?;
    /**
     * @stability stable
     */
    get idpType(): string;
    /**
     * @stability stable
     */
    set idpType(value: string);
    /**
     * @stability stable
     */
    resetIdpType(): void;
    /**
     * @stability stable
     */
    get idpTypeInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkConnection?;
    /**
     * @stability stable
     */
    get networkConnection(): string;
    /**
     * @stability stable
     */
    set networkConnection(value: string);
    /**
     * @stability stable
     */
    resetNetworkConnection(): void;
    /**
     * @stability stable
     */
    get networkConnectionInput(): string | undefined;
    private _networkExcludes?;
    /**
     * @stability stable
     */
    get networkExcludes(): string[];
    /**
     * @stability stable
     */
    set networkExcludes(value: string[]);
    /**
     * @stability stable
     */
    resetNetworkExcludes(): void;
    /**
     * @stability stable
     */
    get networkExcludesInput(): string[] | undefined;
    private _networkIncludes?;
    /**
     * @stability stable
     */
    get networkIncludes(): string[];
    /**
     * @stability stable
     */
    set networkIncludes(value: string[]);
    /**
     * @stability stable
     */
    resetNetworkIncludes(): void;
    /**
     * @stability stable
     */
    get networkIncludesInput(): string[] | undefined;
    private _policyId?;
    /**
     * @stability stable
     */
    get policyId(): string;
    /**
     * @stability stable
     */
    set policyId(value: string);
    /**
     * @stability stable
     */
    resetPolicyId(): void;
    /**
     * @stability stable
     */
    get policyIdInput(): string | undefined;
    private _policyid?;
    /**
     * @stability stable
     */
    get policyid(): string;
    /**
     * @stability stable
     */
    set policyid(value: string);
    /**
     * @stability stable
     */
    resetPolicyid(): void;
    /**
     * @stability stable
     */
    get policyidInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _userIdentifierAttribute?;
    /**
     * @stability stable
     */
    get userIdentifierAttribute(): string;
    /**
     * @stability stable
     */
    set userIdentifierAttribute(value: string);
    /**
     * @stability stable
     */
    resetUserIdentifierAttribute(): void;
    /**
     * @stability stable
     */
    get userIdentifierAttributeInput(): string | undefined;
    private _userIdentifierType?;
    /**
     * @stability stable
     */
    get userIdentifierType(): string;
    /**
     * @stability stable
     */
    set userIdentifierType(value: string);
    /**
     * @stability stable
     */
    resetUserIdentifierType(): void;
    /**
     * @stability stable
     */
    get userIdentifierTypeInput(): string | undefined;
    private _appExclude?;
    /**
     * @stability stable
     */
    get appExclude(): PolicyRuleIdpDiscoveryAppExclude[];
    /**
     * @stability stable
     */
    set appExclude(value: PolicyRuleIdpDiscoveryAppExclude[]);
    /**
     * @stability stable
     */
    resetAppExclude(): void;
    /**
     * @stability stable
     */
    get appExcludeInput(): PolicyRuleIdpDiscoveryAppExclude[] | undefined;
    private _appInclude?;
    /**
     * @stability stable
     */
    get appInclude(): PolicyRuleIdpDiscoveryAppInclude[];
    /**
     * @stability stable
     */
    set appInclude(value: PolicyRuleIdpDiscoveryAppInclude[]);
    /**
     * @stability stable
     */
    resetAppInclude(): void;
    /**
     * @stability stable
     */
    get appIncludeInput(): PolicyRuleIdpDiscoveryAppInclude[] | undefined;
    private _platformInclude?;
    /**
     * @stability stable
     */
    get platformInclude(): PolicyRuleIdpDiscoveryPlatformInclude[];
    /**
     * @stability stable
     */
    set platformInclude(value: PolicyRuleIdpDiscoveryPlatformInclude[]);
    /**
     * @stability stable
     */
    resetPlatformInclude(): void;
    /**
     * @stability stable
     */
    get platformIncludeInput(): PolicyRuleIdpDiscoveryPlatformInclude[] | undefined;
    private _userIdentifierPatterns?;
    /**
     * @stability stable
     */
    get userIdentifierPatterns(): PolicyRuleIdpDiscoveryUserIdentifierPatterns[];
    /**
     * @stability stable
     */
    set userIdentifierPatterns(value: PolicyRuleIdpDiscoveryUserIdentifierPatterns[]);
    /**
     * @stability stable
     */
    resetUserIdentifierPatterns(): void;
    /**
     * @stability stable
     */
    get userIdentifierPatternsInput(): PolicyRuleIdpDiscoveryUserIdentifierPatterns[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
