import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PolicyRuleProfileEnrollmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Allow or deny access based on the rule conditions: ALLOW or DENY.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment.html#access PolicyRuleProfileEnrollment#access}
     *
     * @stability stable
     */
    readonly access?: string;
    /**
     * Indicates whether email verification should occur before access is granted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment.html#email_verification PolicyRuleProfileEnrollment#email_verification}
     *
     * @stability stable
     */
    readonly emailVerification?: boolean | cdktf.IResolvable;
    /**
     * ID of a Registration Inline Hook.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment.html#inline_hook_id PolicyRuleProfileEnrollment#inline_hook_id}
     *
     * @stability stable
     */
    readonly inlineHookId?: string;
    /**
     * ID of the policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment.html#policy_id PolicyRuleProfileEnrollment#policy_id}
     *
     * @stability stable
     */
    readonly policyId: string;
    /**
     * The ID of a Group that this User should be added to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment.html#target_group_id PolicyRuleProfileEnrollment#target_group_id}
     *
     * @stability stable
     */
    readonly targetGroupId?: string;
    /**
     * Which action should be taken if this User is new.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment.html#unknown_user_action PolicyRuleProfileEnrollment#unknown_user_action}
     *
     * @stability stable
     */
    readonly unknownUserAction: string;
    /**
     * profile_attributes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment.html#profile_attributes PolicyRuleProfileEnrollment#profile_attributes}
     *
     * @stability stable
     */
    readonly profileAttributes?: PolicyRuleProfileEnrollmentProfileAttributes[];
}
/**
 * @stability stable
 */
export interface PolicyRuleProfileEnrollmentProfileAttributes {
    /**
     * A display-friendly label for this property.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment.html#label PolicyRuleProfileEnrollment#label}
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * The name of a User Profile property.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment.html#name PolicyRuleProfileEnrollment#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Indicates if this property is required for enrollment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment.html#required PolicyRuleProfileEnrollment#required}
     *
     * @stability stable
     */
    readonly required?: boolean | cdktf.IResolvable;
}
export declare function policyRuleProfileEnrollmentProfileAttributesToTerraform(struct?: PolicyRuleProfileEnrollmentProfileAttributes): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment.html okta_policy_rule_profile_enrollment}.
 *
 * @stability stable
 */
export declare class PolicyRuleProfileEnrollment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_rule_profile_enrollment.html okta_policy_rule_profile_enrollment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PolicyRuleProfileEnrollmentConfig);
    private _access?;
    /**
     * @stability stable
     */
    get access(): string;
    /**
     * @stability stable
     */
    set access(value: string);
    /**
     * @stability stable
     */
    resetAccess(): void;
    /**
     * @stability stable
     */
    get accessInput(): string | undefined;
    private _emailVerification?;
    /**
     * @stability stable
     */
    get emailVerification(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set emailVerification(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEmailVerification(): void;
    /**
     * @stability stable
     */
    get emailVerificationInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _inlineHookId?;
    /**
     * @stability stable
     */
    get inlineHookId(): string;
    /**
     * @stability stable
     */
    set inlineHookId(value: string);
    /**
     * @stability stable
     */
    resetInlineHookId(): void;
    /**
     * @stability stable
     */
    get inlineHookIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _policyId?;
    /**
     * @stability stable
     */
    get policyId(): string;
    /**
     * @stability stable
     */
    set policyId(value: string);
    /**
     * @stability stable
     */
    get policyIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _targetGroupId?;
    /**
     * @stability stable
     */
    get targetGroupId(): string;
    /**
     * @stability stable
     */
    set targetGroupId(value: string);
    /**
     * @stability stable
     */
    resetTargetGroupId(): void;
    /**
     * @stability stable
     */
    get targetGroupIdInput(): string | undefined;
    private _unknownUserAction?;
    /**
     * @stability stable
     */
    get unknownUserAction(): string;
    /**
     * @stability stable
     */
    set unknownUserAction(value: string);
    /**
     * @stability stable
     */
    get unknownUserActionInput(): string | undefined;
    private _profileAttributes?;
    /**
     * @stability stable
     */
    get profileAttributes(): PolicyRuleProfileEnrollmentProfileAttributes[];
    /**
     * @stability stable
     */
    set profileAttributes(value: PolicyRuleProfileEnrollmentProfileAttributes[]);
    /**
     * @stability stable
     */
    resetProfileAttributes(): void;
    /**
     * @stability stable
     */
    get profileAttributesInput(): PolicyRuleProfileEnrollmentProfileAttributes[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
