import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PolicySignonConfig extends cdktf.TerraformMetaArguments {
    /**
     * Policy Description.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_signon.html#description PolicySignon#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * List of Group IDs to Include.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_signon.html#groups_included PolicySignon#groups_included}
     *
     * @stability stable
     */
    readonly groupsIncluded?: string[];
    /**
     * Policy Name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_signon.html#name PolicySignon#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Policy Priority, this attribute can be set to a valid priority.
     *
     * To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_signon.html#priority PolicySignon#priority}
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Policy Status: ACTIVE or INACTIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/policy_signon.html#status PolicySignon#status}
     *
     * @stability stable
     */
    readonly status?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/policy_signon.html okta_policy_signon}.
 *
 * @stability stable
 */
export declare class PolicySignon extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/policy_signon.html okta_policy_signon} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PolicySignonConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _groupsIncluded?;
    /**
     * @stability stable
     */
    get groupsIncluded(): string[];
    /**
     * @stability stable
     */
    set groupsIncluded(value: string[]);
    /**
     * @stability stable
     */
    resetGroupsIncluded(): void;
    /**
     * @stability stable
     */
    get groupsIncludedInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
