import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ProfileMappingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether apply the changes to all users with this profile after updating or creating the these mappings.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping.html#always_apply ProfileMapping#always_apply}
     *
     * @stability stable
     */
    readonly alwaysApply?: boolean | cdktf.IResolvable;
    /**
     * When turned on this flag will trigger the provider to delete mapping properties that are not defined in config.
     *
     * By default, we do not delete missing properties.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping.html#delete_when_absent ProfileMapping#delete_when_absent}
     *
     * @stability stable
     */
    readonly deleteWhenAbsent?: boolean | cdktf.IResolvable;
    /**
     * The source id of the mapping to manage.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping.html#source_id ProfileMapping#source_id}
     *
     * @stability stable
     */
    readonly sourceId: string;
    /**
     * The target id of the mapping to manage.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping.html#target_id ProfileMapping#target_id}
     *
     * @stability stable
     */
    readonly targetId: string;
    /**
     * mappings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping.html#mappings ProfileMapping#mappings}
     *
     * @stability stable
     */
    readonly mappings?: ProfileMappingMappings[];
}
/**
 * @stability stable
 */
export interface ProfileMappingMappings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping.html#expression ProfileMapping#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * The mapping property key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping.html#id ProfileMapping#id}
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping.html#push_status ProfileMapping#push_status}.
     *
     * @stability stable
     */
    readonly pushStatus?: string;
}
export declare function profileMappingMappingsToTerraform(struct?: ProfileMappingMappings): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping.html okta_profile_mapping}.
 *
 * @stability stable
 */
export declare class ProfileMapping extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/profile_mapping.html okta_profile_mapping} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ProfileMappingConfig);
    private _alwaysApply?;
    /**
     * @stability stable
     */
    get alwaysApply(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set alwaysApply(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAlwaysApply(): void;
    /**
     * @stability stable
     */
    get alwaysApplyInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteWhenAbsent?;
    /**
     * @stability stable
     */
    get deleteWhenAbsent(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deleteWhenAbsent(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeleteWhenAbsent(): void;
    /**
     * @stability stable
     */
    get deleteWhenAbsentInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _sourceId?;
    /**
     * @stability stable
     */
    get sourceId(): string;
    /**
     * @stability stable
     */
    set sourceId(value: string);
    /**
     * @stability stable
     */
    get sourceIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get sourceName(): string;
    /**
     * @stability stable
     */
    get sourceType(): string;
    private _targetId?;
    /**
     * @stability stable
     */
    get targetId(): string;
    /**
     * @stability stable
     */
    set targetId(value: string);
    /**
     * @stability stable
     */
    get targetIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get targetName(): string;
    /**
     * @stability stable
     */
    get targetType(): string;
    private _mappings?;
    /**
     * @stability stable
     */
    get mappings(): ProfileMappingMappings[];
    /**
     * @stability stable
     */
    set mappings(value: ProfileMappingMappings[]);
    /**
     * @stability stable
     */
    resetMappings(): void;
    /**
     * @stability stable
     */
    get mappingsInput(): ProfileMappingMappings[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
