import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RateLimitingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Called during authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/rate_limiting.html#authorize RateLimiting#authorize}
     *
     * @stability stable
     */
    readonly authorize: string;
    /**
     * Enables rate limit warning, violation, notification emails and banners when this org meets rate limits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/rate_limiting.html#communications_enabled RateLimiting#communications_enabled}
     *
     * @stability stable
     */
    readonly communicationsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Called when accessing the Okta hosted login page.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/rate_limiting.html#login RateLimiting#login}
     *
     * @stability stable
     */
    readonly login: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/rate_limiting.html okta_rate_limiting}.
 *
 * @stability stable
 */
export declare class RateLimiting extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/rate_limiting.html okta_rate_limiting} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RateLimitingConfig);
    private _authorize?;
    /**
     * @stability stable
     */
    get authorize(): string;
    /**
     * @stability stable
     */
    set authorize(value: string);
    /**
     * @stability stable
     */
    get authorizeInput(): string | undefined;
    private _communicationsEnabled?;
    /**
     * @stability stable
     */
    get communicationsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set communicationsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCommunicationsEnabled(): void;
    /**
     * @stability stable
     */
    get communicationsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _login?;
    /**
     * @stability stable
     */
    get login(): string;
    /**
     * @stability stable
     */
    set login(value: string);
    /**
     * @stability stable
     */
    get loginInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
