import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ResourceSetConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of the Resource Set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/resource_set.html#description ResourceSet#description}
     *
     * @stability stable
     */
    readonly description: string;
    /**
     * Unique name given to the Resource Set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/resource_set.html#label ResourceSet#label}
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * The endpoints that reference the resources to be included in the new Resource Set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/resource_set.html#resources ResourceSet#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/resource_set.html okta_resource_set}.
 *
 * @stability stable
 */
export declare class ResourceSet extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/resource_set.html okta_resource_set} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ResourceSetConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _resources?;
    /**
     * @stability stable
     */
    get resources(): string[];
    /**
     * @stability stable
     */
    set resources(value: string[]);
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
