import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RoleSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Type of the notification.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/role_subscription.html#notification_type RoleSubscription#notification_type}
     *
     * @stability stable
     */
    readonly notificationType: string;
    /**
     * Type of the role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/role_subscription.html#role_type RoleSubscription#role_type}
     *
     * @stability stable
     */
    readonly roleType: string;
    /**
     * Status of subscription.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/role_subscription.html#status RoleSubscription#status}
     *
     * @stability stable
     */
    readonly status?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/role_subscription.html okta_role_subscription}.
 *
 * @stability stable
 */
export declare class RoleSubscription extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/role_subscription.html okta_role_subscription} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RoleSubscriptionConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _notificationType?;
    /**
     * @stability stable
     */
    get notificationType(): string;
    /**
     * @stability stable
     */
    set notificationType(value: string);
    /**
     * @stability stable
     */
    get notificationTypeInput(): string | undefined;
    private _roleType?;
    /**
     * @stability stable
     */
    get roleType(): string;
    /**
     * @stability stable
     */
    set roleType(value: string);
    /**
     * @stability stable
     */
    get roleTypeInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
