import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SamlIdpSigningKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * base64-encoded X.509 certificate chain with DER encoding.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp_signing_key.html#x5c SamlIdpSigningKey#x5c}
     *
     * @stability stable
     */
    readonly x5C: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/saml_idp_signing_key.html okta_saml_idp_signing_key}.
 *
 * @stability stable
 */
export declare class SamlIdpSigningKey extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/saml_idp_signing_key.html okta_saml_idp_signing_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SamlIdpSigningKeyConfig);
    /**
     * @stability stable
     */
    get created(): string;
    /**
     * @stability stable
     */
    get expiresAt(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get kid(): string;
    /**
     * @stability stable
     */
    get kty(): string;
    /**
     * @stability stable
     */
    get use(): string;
    private _x5C?;
    /**
     * @stability stable
     */
    get x5C(): string[];
    /**
     * @stability stable
     */
    set x5C(value: string[]);
    /**
     * @stability stable
     */
    get x5CInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get x5TS256(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
