import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SamlIdpConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#account_link_action SamlIdp#account_link_action}.
     *
     * @stability stable
     */
    readonly accountLinkAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#account_link_group_include SamlIdp#account_link_group_include}.
     *
     * @stability stable
     */
    readonly accountLinkGroupInclude?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#acs_binding SamlIdp#acs_binding}.
     *
     * @stability stable
     */
    readonly acsBinding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#acs_type SamlIdp#acs_type}.
     *
     * @stability stable
     */
    readonly acsType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#deprovisioned_action SamlIdp#deprovisioned_action}.
     *
     * @stability stable
     */
    readonly deprovisionedAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#groups_action SamlIdp#groups_action}.
     *
     * @stability stable
     */
    readonly groupsAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#groups_assignment SamlIdp#groups_assignment}.
     *
     * @stability stable
     */
    readonly groupsAssignment?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#groups_attribute SamlIdp#groups_attribute}.
     *
     * @stability stable
     */
    readonly groupsAttribute?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#groups_filter SamlIdp#groups_filter}.
     *
     * @stability stable
     */
    readonly groupsFilter?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#issuer SamlIdp#issuer}.
     *
     * @stability stable
     */
    readonly issuer: string;
    /**
     * Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#issuer_mode SamlIdp#issuer_mode}
     *
     * @stability stable
     */
    readonly issuerMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#kid SamlIdp#kid}.
     *
     * @stability stable
     */
    readonly kid: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#max_clock_skew SamlIdp#max_clock_skew}.
     *
     * @stability stable
     */
    readonly maxClockSkew?: number;
    /**
     * Name of the IdP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#name SamlIdp#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#name_format SamlIdp#name_format}.
     *
     * @stability stable
     */
    readonly nameFormat?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#profile_master SamlIdp#profile_master}.
     *
     * @stability stable
     */
    readonly profileMaster?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#provisioning_action SamlIdp#provisioning_action}.
     *
     * @stability stable
     */
    readonly provisioningAction?: string;
    /**
     * algorithm to use to sign requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#request_signature_algorithm SamlIdp#request_signature_algorithm}
     *
     * @stability stable
     */
    readonly requestSignatureAlgorithm?: string;
    /**
     * algorithm to use to sign response.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#request_signature_scope SamlIdp#request_signature_scope}
     *
     * @stability stable
     */
    readonly requestSignatureScope?: string;
    /**
     * algorithm to use to sign requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#response_signature_algorithm SamlIdp#response_signature_algorithm}
     *
     * @stability stable
     */
    readonly responseSignatureAlgorithm?: string;
    /**
     * algorithm to use to sign response.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#response_signature_scope SamlIdp#response_signature_scope}
     *
     * @stability stable
     */
    readonly responseSignatureScope?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#sso_binding SamlIdp#sso_binding}.
     *
     * @stability stable
     */
    readonly ssoBinding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#sso_destination SamlIdp#sso_destination}.
     *
     * @stability stable
     */
    readonly ssoDestination?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#sso_url SamlIdp#sso_url}.
     *
     * @stability stable
     */
    readonly ssoUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#status SamlIdp#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#subject_filter SamlIdp#subject_filter}.
     *
     * @stability stable
     */
    readonly subjectFilter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#subject_format SamlIdp#subject_format}.
     *
     * @stability stable
     */
    readonly subjectFormat?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#subject_match_attribute SamlIdp#subject_match_attribute}.
     *
     * @stability stable
     */
    readonly subjectMatchAttribute?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#subject_match_type SamlIdp#subject_match_type}.
     *
     * @stability stable
     */
    readonly subjectMatchType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#suspended_action SamlIdp#suspended_action}.
     *
     * @stability stable
     */
    readonly suspendedAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html#username_template SamlIdp#username_template}.
     *
     * @stability stable
     */
    readonly usernameTemplate?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html okta_saml_idp}.
 *
 * @stability stable
 */
export declare class SamlIdp extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/saml_idp.html okta_saml_idp} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SamlIdpConfig);
    private _accountLinkAction?;
    /**
     * @stability stable
     */
    get accountLinkAction(): string;
    /**
     * @stability stable
     */
    set accountLinkAction(value: string);
    /**
     * @stability stable
     */
    resetAccountLinkAction(): void;
    /**
     * @stability stable
     */
    get accountLinkActionInput(): string | undefined;
    private _accountLinkGroupInclude?;
    /**
     * @stability stable
     */
    get accountLinkGroupInclude(): string[];
    /**
     * @stability stable
     */
    set accountLinkGroupInclude(value: string[]);
    /**
     * @stability stable
     */
    resetAccountLinkGroupInclude(): void;
    /**
     * @stability stable
     */
    get accountLinkGroupIncludeInput(): string[] | undefined;
    private _acsBinding?;
    /**
     * @stability stable
     */
    get acsBinding(): string;
    /**
     * @stability stable
     */
    set acsBinding(value: string);
    /**
     * @stability stable
     */
    resetAcsBinding(): void;
    /**
     * @stability stable
     */
    get acsBindingInput(): string | undefined;
    private _acsType?;
    /**
     * @stability stable
     */
    get acsType(): string;
    /**
     * @stability stable
     */
    set acsType(value: string);
    /**
     * @stability stable
     */
    resetAcsType(): void;
    /**
     * @stability stable
     */
    get acsTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get audience(): string;
    private _deprovisionedAction?;
    /**
     * @stability stable
     */
    get deprovisionedAction(): string;
    /**
     * @stability stable
     */
    set deprovisionedAction(value: string);
    /**
     * @stability stable
     */
    resetDeprovisionedAction(): void;
    /**
     * @stability stable
     */
    get deprovisionedActionInput(): string | undefined;
    private _groupsAction?;
    /**
     * @stability stable
     */
    get groupsAction(): string;
    /**
     * @stability stable
     */
    set groupsAction(value: string);
    /**
     * @stability stable
     */
    resetGroupsAction(): void;
    /**
     * @stability stable
     */
    get groupsActionInput(): string | undefined;
    private _groupsAssignment?;
    /**
     * @stability stable
     */
    get groupsAssignment(): string[];
    /**
     * @stability stable
     */
    set groupsAssignment(value: string[]);
    /**
     * @stability stable
     */
    resetGroupsAssignment(): void;
    /**
     * @stability stable
     */
    get groupsAssignmentInput(): string[] | undefined;
    private _groupsAttribute?;
    /**
     * @stability stable
     */
    get groupsAttribute(): string;
    /**
     * @stability stable
     */
    set groupsAttribute(value: string);
    /**
     * @stability stable
     */
    resetGroupsAttribute(): void;
    /**
     * @stability stable
     */
    get groupsAttributeInput(): string | undefined;
    private _groupsFilter?;
    /**
     * @stability stable
     */
    get groupsFilter(): string[];
    /**
     * @stability stable
     */
    set groupsFilter(value: string[]);
    /**
     * @stability stable
     */
    resetGroupsFilter(): void;
    /**
     * @stability stable
     */
    get groupsFilterInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _issuer?;
    /**
     * @stability stable
     */
    get issuer(): string;
    /**
     * @stability stable
     */
    set issuer(value: string);
    /**
     * @stability stable
     */
    get issuerInput(): string | undefined;
    private _issuerMode?;
    /**
     * @stability stable
     */
    get issuerMode(): string;
    /**
     * @stability stable
     */
    set issuerMode(value: string);
    /**
     * @stability stable
     */
    resetIssuerMode(): void;
    /**
     * @stability stable
     */
    get issuerModeInput(): string | undefined;
    private _kid?;
    /**
     * @stability stable
     */
    get kid(): string;
    /**
     * @stability stable
     */
    set kid(value: string);
    /**
     * @stability stable
     */
    get kidInput(): string | undefined;
    private _maxClockSkew?;
    /**
     * @stability stable
     */
    get maxClockSkew(): number;
    /**
     * @stability stable
     */
    set maxClockSkew(value: number);
    /**
     * @stability stable
     */
    resetMaxClockSkew(): void;
    /**
     * @stability stable
     */
    get maxClockSkewInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nameFormat?;
    /**
     * @stability stable
     */
    get nameFormat(): string;
    /**
     * @stability stable
     */
    set nameFormat(value: string);
    /**
     * @stability stable
     */
    resetNameFormat(): void;
    /**
     * @stability stable
     */
    get nameFormatInput(): string | undefined;
    private _profileMaster?;
    /**
     * @stability stable
     */
    get profileMaster(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set profileMaster(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProfileMaster(): void;
    /**
     * @stability stable
     */
    get profileMasterInput(): boolean | cdktf.IResolvable | undefined;
    private _provisioningAction?;
    /**
     * @stability stable
     */
    get provisioningAction(): string;
    /**
     * @stability stable
     */
    set provisioningAction(value: string);
    /**
     * @stability stable
     */
    resetProvisioningAction(): void;
    /**
     * @stability stable
     */
    get provisioningActionInput(): string | undefined;
    private _requestSignatureAlgorithm?;
    /**
     * @stability stable
     */
    get requestSignatureAlgorithm(): string;
    /**
     * @stability stable
     */
    set requestSignatureAlgorithm(value: string);
    /**
     * @stability stable
     */
    resetRequestSignatureAlgorithm(): void;
    /**
     * @stability stable
     */
    get requestSignatureAlgorithmInput(): string | undefined;
    private _requestSignatureScope?;
    /**
     * @stability stable
     */
    get requestSignatureScope(): string;
    /**
     * @stability stable
     */
    set requestSignatureScope(value: string);
    /**
     * @stability stable
     */
    resetRequestSignatureScope(): void;
    /**
     * @stability stable
     */
    get requestSignatureScopeInput(): string | undefined;
    private _responseSignatureAlgorithm?;
    /**
     * @stability stable
     */
    get responseSignatureAlgorithm(): string;
    /**
     * @stability stable
     */
    set responseSignatureAlgorithm(value: string);
    /**
     * @stability stable
     */
    resetResponseSignatureAlgorithm(): void;
    /**
     * @stability stable
     */
    get responseSignatureAlgorithmInput(): string | undefined;
    private _responseSignatureScope?;
    /**
     * @stability stable
     */
    get responseSignatureScope(): string;
    /**
     * @stability stable
     */
    set responseSignatureScope(value: string);
    /**
     * @stability stable
     */
    resetResponseSignatureScope(): void;
    /**
     * @stability stable
     */
    get responseSignatureScopeInput(): string | undefined;
    private _ssoBinding?;
    /**
     * @stability stable
     */
    get ssoBinding(): string;
    /**
     * @stability stable
     */
    set ssoBinding(value: string);
    /**
     * @stability stable
     */
    resetSsoBinding(): void;
    /**
     * @stability stable
     */
    get ssoBindingInput(): string | undefined;
    private _ssoDestination?;
    /**
     * @stability stable
     */
    get ssoDestination(): string;
    /**
     * @stability stable
     */
    set ssoDestination(value: string);
    /**
     * @stability stable
     */
    resetSsoDestination(): void;
    /**
     * @stability stable
     */
    get ssoDestinationInput(): string | undefined;
    private _ssoUrl?;
    /**
     * @stability stable
     */
    get ssoUrl(): string;
    /**
     * @stability stable
     */
    set ssoUrl(value: string);
    /**
     * @stability stable
     */
    get ssoUrlInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _subjectFilter?;
    /**
     * @stability stable
     */
    get subjectFilter(): string;
    /**
     * @stability stable
     */
    set subjectFilter(value: string);
    /**
     * @stability stable
     */
    resetSubjectFilter(): void;
    /**
     * @stability stable
     */
    get subjectFilterInput(): string | undefined;
    private _subjectFormat?;
    /**
     * @stability stable
     */
    get subjectFormat(): string[];
    /**
     * @stability stable
     */
    set subjectFormat(value: string[]);
    /**
     * @stability stable
     */
    resetSubjectFormat(): void;
    /**
     * @stability stable
     */
    get subjectFormatInput(): string[] | undefined;
    private _subjectMatchAttribute?;
    /**
     * @stability stable
     */
    get subjectMatchAttribute(): string;
    /**
     * @stability stable
     */
    set subjectMatchAttribute(value: string);
    /**
     * @stability stable
     */
    resetSubjectMatchAttribute(): void;
    /**
     * @stability stable
     */
    get subjectMatchAttributeInput(): string | undefined;
    private _subjectMatchType?;
    /**
     * @stability stable
     */
    get subjectMatchType(): string;
    /**
     * @stability stable
     */
    set subjectMatchType(value: string);
    /**
     * @stability stable
     */
    resetSubjectMatchType(): void;
    /**
     * @stability stable
     */
    get subjectMatchTypeInput(): string | undefined;
    private _suspendedAction?;
    /**
     * @stability stable
     */
    get suspendedAction(): string;
    /**
     * @stability stable
     */
    set suspendedAction(value: string);
    /**
     * @stability stable
     */
    resetSuspendedAction(): void;
    /**
     * @stability stable
     */
    get suspendedActionInput(): string | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    private _usernameTemplate?;
    /**
     * @stability stable
     */
    get usernameTemplate(): string;
    /**
     * @stability stable
     */
    set usernameTemplate(value: string);
    /**
     * @stability stable
     */
    resetUsernameTemplate(): void;
    /**
     * @stability stable
     */
    get usernameTemplateInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
