import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecurePasswordStoreAppConfig extends cdktf.TerraformMetaArguments {
    /**
     * Custom error page URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#accessibility_error_redirect_url SecurePasswordStoreApp#accessibility_error_redirect_url}
     *
     * @stability stable
     */
    readonly accessibilityErrorRedirectUrl?: string;
    /**
     * Custom login page URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#accessibility_login_redirect_url SecurePasswordStoreApp#accessibility_login_redirect_url}
     *
     * @stability stable
     */
    readonly accessibilityLoginRedirectUrl?: string;
    /**
     * Enable self service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#accessibility_self_service SecurePasswordStoreApp#accessibility_self_service}
     *
     * @stability stable
     */
    readonly accessibilitySelfService?: boolean | cdktf.IResolvable;
    /**
     * Application notes for admins.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#admin_note SecurePasswordStoreApp#admin_note}
     *
     * @stability stable
     */
    readonly adminNote?: string;
    /**
     * Displays specific appLinks for the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#app_links_json SecurePasswordStoreApp#app_links_json}
     *
     * @stability stable
     */
    readonly appLinksJson?: string;
    /**
     * Display auto submit toolbar.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#auto_submit_toolbar SecurePasswordStoreApp#auto_submit_toolbar}
     *
     * @stability stable
     */
    readonly autoSubmitToolbar?: boolean | cdktf.IResolvable;
    /**
     * Application credentials scheme.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#credentials_scheme SecurePasswordStoreApp#credentials_scheme}
     *
     * @stability stable
     */
    readonly credentialsScheme?: string;
    /**
     * Application notes for end users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#enduser_note SecurePasswordStoreApp#enduser_note}
     *
     * @stability stable
     */
    readonly enduserNote?: string;
    /**
     * Groups associated with the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#groups SecurePasswordStoreApp#groups}
     *
     * @stability stable
     */
    readonly groups?: string[];
    /**
     * Do not display application icon on mobile app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#hide_ios SecurePasswordStoreApp#hide_ios}
     *
     * @stability stable
     */
    readonly hideIos?: boolean | cdktf.IResolvable;
    /**
     * Do not display application icon to users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#hide_web SecurePasswordStoreApp#hide_web}
     *
     * @stability stable
     */
    readonly hideWeb?: boolean | cdktf.IResolvable;
    /**
     * Pretty name of app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#label SecurePasswordStoreApp#label}
     *
     * @stability stable
     */
    readonly label: string;
    /**
     * Local path to logo of the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#logo SecurePasswordStoreApp#logo}
     *
     * @stability stable
     */
    readonly logo?: string;
    /**
     * Name of optional param in the login form.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#optional_field1 SecurePasswordStoreApp#optional_field1}
     *
     * @stability stable
     */
    readonly optionalField1?: string;
    /**
     * Name of optional value in login form.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#optional_field1_value SecurePasswordStoreApp#optional_field1_value}
     *
     * @stability stable
     */
    readonly optionalField1Value?: string;
    /**
     * Name of optional param in the login form.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#optional_field2 SecurePasswordStoreApp#optional_field2}
     *
     * @stability stable
     */
    readonly optionalField2?: string;
    /**
     * Name of optional value in login form.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#optional_field2_value SecurePasswordStoreApp#optional_field2_value}
     *
     * @stability stable
     */
    readonly optionalField2Value?: string;
    /**
     * Name of optional param in the login form.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#optional_field3 SecurePasswordStoreApp#optional_field3}
     *
     * @stability stable
     */
    readonly optionalField3?: string;
    /**
     * Name of optional value in login form.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#optional_field3_value SecurePasswordStoreApp#optional_field3_value}
     *
     * @stability stable
     */
    readonly optionalField3Value?: string;
    /**
     * Login password field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#password_field SecurePasswordStoreApp#password_field}
     *
     * @stability stable
     */
    readonly passwordField: string;
    /**
     * Allow user to reveal password.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#reveal_password SecurePasswordStoreApp#reveal_password}
     *
     * @stability stable
     */
    readonly revealPassword?: boolean | cdktf.IResolvable;
    /**
     * Shared password, required for certain schemes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#shared_password SecurePasswordStoreApp#shared_password}
     *
     * @stability stable
     */
    readonly sharedPassword?: string;
    /**
     * Shared username, required for certain schemes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#shared_username SecurePasswordStoreApp#shared_username}
     *
     * @stability stable
     */
    readonly sharedUsername?: string;
    /**
     * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#skip_groups SecurePasswordStoreApp#skip_groups}
     *
     * @stability stable
     */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
     * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#skip_users SecurePasswordStoreApp#skip_users}
     *
     * @stability stable
     */
    readonly skipUsers?: boolean | cdktf.IResolvable;
    /**
     * Status of application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#status SecurePasswordStoreApp#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Login URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#url SecurePasswordStoreApp#url}
     *
     * @stability stable
     */
    readonly url: string;
    /**
     * Username template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#user_name_template SecurePasswordStoreApp#user_name_template}
     *
     * @stability stable
     */
    readonly userNameTemplate?: string;
    /**
     * Push username on update.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#user_name_template_push_status SecurePasswordStoreApp#user_name_template_push_status}
     *
     * @stability stable
     */
    readonly userNameTemplatePushStatus?: string;
    /**
     * Username template suffix.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#user_name_template_suffix SecurePasswordStoreApp#user_name_template_suffix}
     *
     * @stability stable
     */
    readonly userNameTemplateSuffix?: string;
    /**
     * Username template type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#user_name_template_type SecurePasswordStoreApp#user_name_template_type}
     *
     * @stability stable
     */
    readonly userNameTemplateType?: string;
    /**
     * Login username field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#username_field SecurePasswordStoreApp#username_field}
     *
     * @stability stable
     */
    readonly usernameField: string;
    /**
     * users block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#users SecurePasswordStoreApp#users}
     *
     * @stability stable
     */
    readonly users?: SecurePasswordStoreAppUsers[];
}
/**
 * @stability stable
 */
export interface SecurePasswordStoreAppUsers {
    /**
     * User ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#id SecurePasswordStoreApp#id}
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Password for user application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#password SecurePasswordStoreApp#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Username for user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html#username SecurePasswordStoreApp#username}
     *
     * @stability stable
     */
    readonly username?: string;
}
export declare function securePasswordStoreAppUsersToTerraform(struct?: SecurePasswordStoreAppUsers): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html okta_secure_password_store_app}.
 *
 * @stability stable
 */
export declare class SecurePasswordStoreApp extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/secure_password_store_app.html okta_secure_password_store_app} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SecurePasswordStoreAppConfig);
    private _accessibilityErrorRedirectUrl?;
    /**
     * @stability stable
     */
    get accessibilityErrorRedirectUrl(): string;
    /**
     * @stability stable
     */
    set accessibilityErrorRedirectUrl(value: string);
    /**
     * @stability stable
     */
    resetAccessibilityErrorRedirectUrl(): void;
    /**
     * @stability stable
     */
    get accessibilityErrorRedirectUrlInput(): string | undefined;
    private _accessibilityLoginRedirectUrl?;
    /**
     * @stability stable
     */
    get accessibilityLoginRedirectUrl(): string;
    /**
     * @stability stable
     */
    set accessibilityLoginRedirectUrl(value: string);
    /**
     * @stability stable
     */
    resetAccessibilityLoginRedirectUrl(): void;
    /**
     * @stability stable
     */
    get accessibilityLoginRedirectUrlInput(): string | undefined;
    private _accessibilitySelfService?;
    /**
     * @stability stable
     */
    get accessibilitySelfService(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set accessibilitySelfService(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAccessibilitySelfService(): void;
    /**
     * @stability stable
     */
    get accessibilitySelfServiceInput(): boolean | cdktf.IResolvable | undefined;
    private _adminNote?;
    /**
     * @stability stable
     */
    get adminNote(): string;
    /**
     * @stability stable
     */
    set adminNote(value: string);
    /**
     * @stability stable
     */
    resetAdminNote(): void;
    /**
     * @stability stable
     */
    get adminNoteInput(): string | undefined;
    private _appLinksJson?;
    /**
     * @stability stable
     */
    get appLinksJson(): string;
    /**
     * @stability stable
     */
    set appLinksJson(value: string);
    /**
     * @stability stable
     */
    resetAppLinksJson(): void;
    /**
     * @stability stable
     */
    get appLinksJsonInput(): string | undefined;
    private _autoSubmitToolbar?;
    /**
     * @stability stable
     */
    get autoSubmitToolbar(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoSubmitToolbar(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoSubmitToolbar(): void;
    /**
     * @stability stable
     */
    get autoSubmitToolbarInput(): boolean | cdktf.IResolvable | undefined;
    private _credentialsScheme?;
    /**
     * @stability stable
     */
    get credentialsScheme(): string;
    /**
     * @stability stable
     */
    set credentialsScheme(value: string);
    /**
     * @stability stable
     */
    resetCredentialsScheme(): void;
    /**
     * @stability stable
     */
    get credentialsSchemeInput(): string | undefined;
    private _enduserNote?;
    /**
     * @stability stable
     */
    get enduserNote(): string;
    /**
     * @stability stable
     */
    set enduserNote(value: string);
    /**
     * @stability stable
     */
    resetEnduserNote(): void;
    /**
     * @stability stable
     */
    get enduserNoteInput(): string | undefined;
    private _groups?;
    /**
     * @stability stable
     */
    get groups(): string[];
    /**
     * @stability stable
     */
    set groups(value: string[]);
    /**
     * @stability stable
     */
    resetGroups(): void;
    /**
     * @stability stable
     */
    get groupsInput(): string[] | undefined;
    private _hideIos?;
    /**
     * @stability stable
     */
    get hideIos(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hideIos(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHideIos(): void;
    /**
     * @stability stable
     */
    get hideIosInput(): boolean | cdktf.IResolvable | undefined;
    private _hideWeb?;
    /**
     * @stability stable
     */
    get hideWeb(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hideWeb(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHideWeb(): void;
    /**
     * @stability stable
     */
    get hideWebInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _logo?;
    /**
     * @stability stable
     */
    get logo(): string;
    /**
     * @stability stable
     */
    set logo(value: string);
    /**
     * @stability stable
     */
    resetLogo(): void;
    /**
     * @stability stable
     */
    get logoInput(): string | undefined;
    /**
     * @stability stable
     */
    get logoUrl(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _optionalField1?;
    /**
     * @stability stable
     */
    get optionalField1(): string;
    /**
     * @stability stable
     */
    set optionalField1(value: string);
    /**
     * @stability stable
     */
    resetOptionalField1(): void;
    /**
     * @stability stable
     */
    get optionalField1Input(): string | undefined;
    private _optionalField1Value?;
    /**
     * @stability stable
     */
    get optionalField1Value(): string;
    /**
     * @stability stable
     */
    set optionalField1Value(value: string);
    /**
     * @stability stable
     */
    resetOptionalField1Value(): void;
    /**
     * @stability stable
     */
    get optionalField1ValueInput(): string | undefined;
    private _optionalField2?;
    /**
     * @stability stable
     */
    get optionalField2(): string;
    /**
     * @stability stable
     */
    set optionalField2(value: string);
    /**
     * @stability stable
     */
    resetOptionalField2(): void;
    /**
     * @stability stable
     */
    get optionalField2Input(): string | undefined;
    private _optionalField2Value?;
    /**
     * @stability stable
     */
    get optionalField2Value(): string;
    /**
     * @stability stable
     */
    set optionalField2Value(value: string);
    /**
     * @stability stable
     */
    resetOptionalField2Value(): void;
    /**
     * @stability stable
     */
    get optionalField2ValueInput(): string | undefined;
    private _optionalField3?;
    /**
     * @stability stable
     */
    get optionalField3(): string;
    /**
     * @stability stable
     */
    set optionalField3(value: string);
    /**
     * @stability stable
     */
    resetOptionalField3(): void;
    /**
     * @stability stable
     */
    get optionalField3Input(): string | undefined;
    private _optionalField3Value?;
    /**
     * @stability stable
     */
    get optionalField3Value(): string;
    /**
     * @stability stable
     */
    set optionalField3Value(value: string);
    /**
     * @stability stable
     */
    resetOptionalField3Value(): void;
    /**
     * @stability stable
     */
    get optionalField3ValueInput(): string | undefined;
    private _passwordField?;
    /**
     * @stability stable
     */
    get passwordField(): string;
    /**
     * @stability stable
     */
    set passwordField(value: string);
    /**
     * @stability stable
     */
    get passwordFieldInput(): string | undefined;
    private _revealPassword?;
    /**
     * @stability stable
     */
    get revealPassword(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set revealPassword(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRevealPassword(): void;
    /**
     * @stability stable
     */
    get revealPasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _sharedPassword?;
    /**
     * @stability stable
     */
    get sharedPassword(): string;
    /**
     * @stability stable
     */
    set sharedPassword(value: string);
    /**
     * @stability stable
     */
    resetSharedPassword(): void;
    /**
     * @stability stable
     */
    get sharedPasswordInput(): string | undefined;
    private _sharedUsername?;
    /**
     * @stability stable
     */
    get sharedUsername(): string;
    /**
     * @stability stable
     */
    set sharedUsername(value: string);
    /**
     * @stability stable
     */
    resetSharedUsername(): void;
    /**
     * @stability stable
     */
    get sharedUsernameInput(): string | undefined;
    /**
     * @stability stable
     */
    get signOnMode(): string;
    private _skipGroups?;
    /**
     * @stability stable
     */
    get skipGroups(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipGroups(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipGroups(): void;
    /**
     * @stability stable
     */
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    /**
     * @stability stable
     */
    get skipUsers(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipUsers(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipUsers(): void;
    /**
     * @stability stable
     */
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    private _userNameTemplate?;
    /**
     * @stability stable
     */
    get userNameTemplate(): string;
    /**
     * @stability stable
     */
    set userNameTemplate(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplate(): void;
    /**
     * @stability stable
     */
    get userNameTemplateInput(): string | undefined;
    private _userNameTemplatePushStatus?;
    /**
     * @stability stable
     */
    get userNameTemplatePushStatus(): string;
    /**
     * @stability stable
     */
    set userNameTemplatePushStatus(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplatePushStatus(): void;
    /**
     * @stability stable
     */
    get userNameTemplatePushStatusInput(): string | undefined;
    private _userNameTemplateSuffix?;
    /**
     * @stability stable
     */
    get userNameTemplateSuffix(): string;
    /**
     * @stability stable
     */
    set userNameTemplateSuffix(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplateSuffix(): void;
    /**
     * @stability stable
     */
    get userNameTemplateSuffixInput(): string | undefined;
    private _userNameTemplateType?;
    /**
     * @stability stable
     */
    get userNameTemplateType(): string;
    /**
     * @stability stable
     */
    set userNameTemplateType(value: string);
    /**
     * @stability stable
     */
    resetUserNameTemplateType(): void;
    /**
     * @stability stable
     */
    get userNameTemplateTypeInput(): string | undefined;
    private _usernameField?;
    /**
     * @stability stable
     */
    get usernameField(): string;
    /**
     * @stability stable
     */
    set usernameField(value: string);
    /**
     * @stability stable
     */
    get usernameFieldInput(): string | undefined;
    private _users?;
    /**
     * @stability stable
     */
    get users(): SecurePasswordStoreAppUsers[];
    /**
     * @stability stable
     */
    set users(value: SecurePasswordStoreAppUsers[]);
    /**
     * @stability stable
     */
    resetUsers(): void;
    /**
     * @stability stable
     */
    get usersInput(): SecurePasswordStoreAppUsers[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
