import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecurityNotificationEmailsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Notifies end users about suspicious or unrecognized activity from their account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails.html#report_suspicious_activity_enabled SecurityNotificationEmails#report_suspicious_activity_enabled}
     *
     * @stability stable
     */
    readonly reportSuspiciousActivityEnabled?: boolean | cdktf.IResolvable;
    /**
     * Notifies end users of any activity on their account related to MFA factor enrollment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails.html#send_email_for_factor_enrollment_enabled SecurityNotificationEmails#send_email_for_factor_enrollment_enabled}
     *
     * @stability stable
     */
    readonly sendEmailForFactorEnrollmentEnabled?: boolean | cdktf.IResolvable;
    /**
     * Notifies end users that one or more factors have been reset for their account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails.html#send_email_for_factor_reset_enabled SecurityNotificationEmails#send_email_for_factor_reset_enabled}
     *
     * @stability stable
     */
    readonly sendEmailForFactorResetEnabled?: boolean | cdktf.IResolvable;
    /**
     * Notifies end users about new sign-on activity.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails.html#send_email_for_new_device_enabled SecurityNotificationEmails#send_email_for_new_device_enabled}
     *
     * @stability stable
     */
    readonly sendEmailForNewDeviceEnabled?: boolean | cdktf.IResolvable;
    /**
     * Notifies end users that the password for their account has changed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails.html#send_email_for_password_changed_enabled SecurityNotificationEmails#send_email_for_password_changed_enabled}
     *
     * @stability stable
     */
    readonly sendEmailForPasswordChangedEnabled?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails.html okta_security_notification_emails}.
 *
 * @stability stable
 */
export declare class SecurityNotificationEmails extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails.html okta_security_notification_emails} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: SecurityNotificationEmailsConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _reportSuspiciousActivityEnabled?;
    /**
     * @stability stable
     */
    get reportSuspiciousActivityEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set reportSuspiciousActivityEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReportSuspiciousActivityEnabled(): void;
    /**
     * @stability stable
     */
    get reportSuspiciousActivityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sendEmailForFactorEnrollmentEnabled?;
    /**
     * @stability stable
     */
    get sendEmailForFactorEnrollmentEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sendEmailForFactorEnrollmentEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSendEmailForFactorEnrollmentEnabled(): void;
    /**
     * @stability stable
     */
    get sendEmailForFactorEnrollmentEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sendEmailForFactorResetEnabled?;
    /**
     * @stability stable
     */
    get sendEmailForFactorResetEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sendEmailForFactorResetEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSendEmailForFactorResetEnabled(): void;
    /**
     * @stability stable
     */
    get sendEmailForFactorResetEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sendEmailForNewDeviceEnabled?;
    /**
     * @stability stable
     */
    get sendEmailForNewDeviceEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sendEmailForNewDeviceEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSendEmailForNewDeviceEnabled(): void;
    /**
     * @stability stable
     */
    get sendEmailForNewDeviceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sendEmailForPasswordChangedEnabled?;
    /**
     * @stability stable
     */
    get sendEmailForPasswordChangedEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sendEmailForPasswordChangedEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSendEmailForPasswordChangedEnabled(): void;
    /**
     * @stability stable
     */
    get sendEmailForPasswordChangedEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
