"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecurityNotificationEmails = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails.html okta_security_notification_emails}.
 *
 * @stability stable
 */
class SecurityNotificationEmails extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/security_notification_emails.html okta_security_notification_emails} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'okta_security_notification_emails',
            terraformGeneratorMetadata: {
                providerName: 'okta'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._reportSuspiciousActivityEnabled = config.reportSuspiciousActivityEnabled;
        this._sendEmailForFactorEnrollmentEnabled = config.sendEmailForFactorEnrollmentEnabled;
        this._sendEmailForFactorResetEnabled = config.sendEmailForFactorResetEnabled;
        this._sendEmailForNewDeviceEnabled = config.sendEmailForNewDeviceEnabled;
        this._sendEmailForPasswordChangedEnabled = config.sendEmailForPasswordChangedEnabled;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: true, required: false
    /**
     * @stability stable
     */
    get id() {
        return this.getStringAttribute('id');
    }
    /**
     * @stability stable
     */
    get reportSuspiciousActivityEnabled() {
        return this.getBooleanAttribute('report_suspicious_activity_enabled');
    }
    /**
     * @stability stable
     */
    set reportSuspiciousActivityEnabled(value) {
        this._reportSuspiciousActivityEnabled = value;
    }
    /**
     * @stability stable
     */
    resetReportSuspiciousActivityEnabled() {
        this._reportSuspiciousActivityEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get reportSuspiciousActivityEnabledInput() {
        return this._reportSuspiciousActivityEnabled;
    }
    /**
     * @stability stable
     */
    get sendEmailForFactorEnrollmentEnabled() {
        return this.getBooleanAttribute('send_email_for_factor_enrollment_enabled');
    }
    /**
     * @stability stable
     */
    set sendEmailForFactorEnrollmentEnabled(value) {
        this._sendEmailForFactorEnrollmentEnabled = value;
    }
    /**
     * @stability stable
     */
    resetSendEmailForFactorEnrollmentEnabled() {
        this._sendEmailForFactorEnrollmentEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get sendEmailForFactorEnrollmentEnabledInput() {
        return this._sendEmailForFactorEnrollmentEnabled;
    }
    /**
     * @stability stable
     */
    get sendEmailForFactorResetEnabled() {
        return this.getBooleanAttribute('send_email_for_factor_reset_enabled');
    }
    /**
     * @stability stable
     */
    set sendEmailForFactorResetEnabled(value) {
        this._sendEmailForFactorResetEnabled = value;
    }
    /**
     * @stability stable
     */
    resetSendEmailForFactorResetEnabled() {
        this._sendEmailForFactorResetEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get sendEmailForFactorResetEnabledInput() {
        return this._sendEmailForFactorResetEnabled;
    }
    /**
     * @stability stable
     */
    get sendEmailForNewDeviceEnabled() {
        return this.getBooleanAttribute('send_email_for_new_device_enabled');
    }
    /**
     * @stability stable
     */
    set sendEmailForNewDeviceEnabled(value) {
        this._sendEmailForNewDeviceEnabled = value;
    }
    /**
     * @stability stable
     */
    resetSendEmailForNewDeviceEnabled() {
        this._sendEmailForNewDeviceEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get sendEmailForNewDeviceEnabledInput() {
        return this._sendEmailForNewDeviceEnabled;
    }
    /**
     * @stability stable
     */
    get sendEmailForPasswordChangedEnabled() {
        return this.getBooleanAttribute('send_email_for_password_changed_enabled');
    }
    /**
     * @stability stable
     */
    set sendEmailForPasswordChangedEnabled(value) {
        this._sendEmailForPasswordChangedEnabled = value;
    }
    /**
     * @stability stable
     */
    resetSendEmailForPasswordChangedEnabled() {
        this._sendEmailForPasswordChangedEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get sendEmailForPasswordChangedEnabledInput() {
        return this._sendEmailForPasswordChangedEnabled;
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     * @stability stable
     */
    synthesizeAttributes() {
        return {
            report_suspicious_activity_enabled: cdktf.booleanToTerraform(this._reportSuspiciousActivityEnabled),
            send_email_for_factor_enrollment_enabled: cdktf.booleanToTerraform(this._sendEmailForFactorEnrollmentEnabled),
            send_email_for_factor_reset_enabled: cdktf.booleanToTerraform(this._sendEmailForFactorResetEnabled),
            send_email_for_new_device_enabled: cdktf.booleanToTerraform(this._sendEmailForNewDeviceEnabled),
            send_email_for_password_changed_enabled: cdktf.booleanToTerraform(this._sendEmailForPasswordChangedEnabled),
        };
    }
}
exports.SecurityNotificationEmails = SecurityNotificationEmails;
_a = JSII_RTTI_SYMBOL_1;
SecurityNotificationEmails[_a] = { fqn: "@cdktf/provider-okta.SecurityNotificationEmails", version: "0.0.52" };
// =================
// STATIC PROPERTIES
// =================
/**
 * @stability stable
 */
SecurityNotificationEmails.tfResourceType = "okta_security_notification_emails";
//# sourceMappingURL=data:application/json;base64,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