import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SignonPolicyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Allow or deny access based on the rule conditions: ALLOW, DENY or CHALLENGE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#access SignonPolicyRule#access}
     *
     * @stability stable
     */
    readonly access?: string;
    /**
     * Authentication entrypoint: ANY, RADIUS or LDAP_INTERFACE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#authtype SignonPolicyRule#authtype}
     *
     * @stability stable
     */
    readonly authtype?: string;
    /**
     * List of behavior IDs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#behaviors SignonPolicyRule#behaviors}
     *
     * @stability stable
     */
    readonly behaviors?: string[];
    /**
     * Elapsed time before the next MFA challenge.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#mfa_lifetime SignonPolicyRule#mfa_lifetime}
     *
     * @stability stable
     */
    readonly mfaLifetime?: number;
    /**
     * Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: DEVICE, SESSION or ALWAYS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#mfa_prompt SignonPolicyRule#mfa_prompt}
     *
     * @stability stable
     */
    readonly mfaPrompt?: string;
    /**
     * Remember MFA device.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#mfa_remember_device SignonPolicyRule#mfa_remember_device}
     *
     * @stability stable
     */
    readonly mfaRememberDevice?: boolean | cdktf.IResolvable;
    /**
     * Require MFA.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#mfa_required SignonPolicyRule#mfa_required}
     *
     * @stability stable
     */
    readonly mfaRequired?: boolean | cdktf.IResolvable;
    /**
     * Policy Rule Name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#name SignonPolicyRule#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#network_connection SignonPolicyRule#network_connection}
     *
     * @stability stable
     */
    readonly networkConnection?: string;
    /**
     * The zones to exclude.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#network_excludes SignonPolicyRule#network_excludes}
     *
     * @stability stable
     */
    readonly networkExcludes?: string[];
    /**
     * The zones to include.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#network_includes SignonPolicyRule#network_includes}
     *
     * @stability stable
     */
    readonly networkIncludes?: string[];
    /**
     * Policy ID of the Rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#policy_id SignonPolicyRule#policy_id}
     *
     * @stability stable
     */
    readonly policyId?: string;
    /**
     * Policy ID of the Rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#policyid SignonPolicyRule#policyid}
     *
     * @stability stable
     */
    readonly policyid?: string;
    /**
     * Primary factor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#primary_factor SignonPolicyRule#primary_factor}
     *
     * @stability stable
     */
    readonly primaryFactor?: string;
    /**
     * Policy Rule Priority, this attribute can be set to a valid priority.
     *
     * To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#priority SignonPolicyRule#priority}
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Risc level: ANY, LOW, MEDIUM or HIGH.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#risc_level SignonPolicyRule#risc_level}
     *
     * @stability stable
     */
    readonly riscLevel?: string;
    /**
     * Max minutes a session can be idle.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#session_idle SignonPolicyRule#session_idle}
     *
     * @stability stable
     */
    readonly sessionIdle?: number;
    /**
     * Max minutes a session is active: Disable = 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#session_lifetime SignonPolicyRule#session_lifetime}
     *
     * @stability stable
     */
    readonly sessionLifetime?: number;
    /**
     * Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session cookies.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#session_persistent SignonPolicyRule#session_persistent}
     *
     * @stability stable
     */
    readonly sessionPersistent?: boolean | cdktf.IResolvable;
    /**
     * Policy Rule Status: ACTIVE or INACTIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#status SignonPolicyRule#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Set of User IDs to Exclude.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#users_excluded SignonPolicyRule#users_excluded}
     *
     * @stability stable
     */
    readonly usersExcluded?: string[];
    /**
     * factor_sequence block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#factor_sequence SignonPolicyRule#factor_sequence}
     *
     * @stability stable
     */
    readonly factorSequence?: SignonPolicyRuleFactorSequence[];
}
/**
 * @stability stable
 */
export interface SignonPolicyRuleFactorSequenceSecondaryCriteria {
    /**
     * Type of a Factor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#factor_type SignonPolicyRule#factor_type}
     *
     * @stability stable
     */
    readonly factorType: string;
    /**
     * Factor provider.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#provider SignonPolicyRule#provider}
     *
     * @stability stable
     */
    readonly provider: string;
}
export declare function signonPolicyRuleFactorSequenceSecondaryCriteriaToTerraform(struct?: SignonPolicyRuleFactorSequenceSecondaryCriteria): any;
/**
 * @stability stable
 */
export interface SignonPolicyRuleFactorSequence {
    /**
     * Type of a Factor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#primary_criteria_factor_type SignonPolicyRule#primary_criteria_factor_type}
     *
     * @stability stable
     */
    readonly primaryCriteriaFactorType: string;
    /**
     * Factor provider.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#primary_criteria_provider SignonPolicyRule#primary_criteria_provider}
     *
     * @stability stable
     */
    readonly primaryCriteriaProvider: string;
    /**
     * secondary_criteria block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html#secondary_criteria SignonPolicyRule#secondary_criteria}
     *
     * @stability stable
     */
    readonly secondaryCriteria?: SignonPolicyRuleFactorSequenceSecondaryCriteria[];
}
export declare function signonPolicyRuleFactorSequenceToTerraform(struct?: SignonPolicyRuleFactorSequence): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html okta_signon_policy_rule}.
 *
 * @stability stable
 */
export declare class SignonPolicyRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/signon_policy_rule.html okta_signon_policy_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SignonPolicyRuleConfig);
    private _access?;
    /**
     * @stability stable
     */
    get access(): string;
    /**
     * @stability stable
     */
    set access(value: string);
    /**
     * @stability stable
     */
    resetAccess(): void;
    /**
     * @stability stable
     */
    get accessInput(): string | undefined;
    private _authtype?;
    /**
     * @stability stable
     */
    get authtype(): string;
    /**
     * @stability stable
     */
    set authtype(value: string);
    /**
     * @stability stable
     */
    resetAuthtype(): void;
    /**
     * @stability stable
     */
    get authtypeInput(): string | undefined;
    private _behaviors?;
    /**
     * @stability stable
     */
    get behaviors(): string[];
    /**
     * @stability stable
     */
    set behaviors(value: string[]);
    /**
     * @stability stable
     */
    resetBehaviors(): void;
    /**
     * @stability stable
     */
    get behaviorsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _mfaLifetime?;
    /**
     * @stability stable
     */
    get mfaLifetime(): number;
    /**
     * @stability stable
     */
    set mfaLifetime(value: number);
    /**
     * @stability stable
     */
    resetMfaLifetime(): void;
    /**
     * @stability stable
     */
    get mfaLifetimeInput(): number | undefined;
    private _mfaPrompt?;
    /**
     * @stability stable
     */
    get mfaPrompt(): string;
    /**
     * @stability stable
     */
    set mfaPrompt(value: string);
    /**
     * @stability stable
     */
    resetMfaPrompt(): void;
    /**
     * @stability stable
     */
    get mfaPromptInput(): string | undefined;
    private _mfaRememberDevice?;
    /**
     * @stability stable
     */
    get mfaRememberDevice(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set mfaRememberDevice(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMfaRememberDevice(): void;
    /**
     * @stability stable
     */
    get mfaRememberDeviceInput(): boolean | cdktf.IResolvable | undefined;
    private _mfaRequired?;
    /**
     * @stability stable
     */
    get mfaRequired(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set mfaRequired(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMfaRequired(): void;
    /**
     * @stability stable
     */
    get mfaRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkConnection?;
    /**
     * @stability stable
     */
    get networkConnection(): string;
    /**
     * @stability stable
     */
    set networkConnection(value: string);
    /**
     * @stability stable
     */
    resetNetworkConnection(): void;
    /**
     * @stability stable
     */
    get networkConnectionInput(): string | undefined;
    private _networkExcludes?;
    /**
     * @stability stable
     */
    get networkExcludes(): string[];
    /**
     * @stability stable
     */
    set networkExcludes(value: string[]);
    /**
     * @stability stable
     */
    resetNetworkExcludes(): void;
    /**
     * @stability stable
     */
    get networkExcludesInput(): string[] | undefined;
    private _networkIncludes?;
    /**
     * @stability stable
     */
    get networkIncludes(): string[];
    /**
     * @stability stable
     */
    set networkIncludes(value: string[]);
    /**
     * @stability stable
     */
    resetNetworkIncludes(): void;
    /**
     * @stability stable
     */
    get networkIncludesInput(): string[] | undefined;
    private _policyId?;
    /**
     * @stability stable
     */
    get policyId(): string;
    /**
     * @stability stable
     */
    set policyId(value: string);
    /**
     * @stability stable
     */
    resetPolicyId(): void;
    /**
     * @stability stable
     */
    get policyIdInput(): string | undefined;
    private _policyid?;
    /**
     * @stability stable
     */
    get policyid(): string;
    /**
     * @stability stable
     */
    set policyid(value: string);
    /**
     * @stability stable
     */
    resetPolicyid(): void;
    /**
     * @stability stable
     */
    get policyidInput(): string | undefined;
    private _primaryFactor?;
    /**
     * @stability stable
     */
    get primaryFactor(): string;
    /**
     * @stability stable
     */
    set primaryFactor(value: string);
    /**
     * @stability stable
     */
    resetPrimaryFactor(): void;
    /**
     * @stability stable
     */
    get primaryFactorInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _riscLevel?;
    /**
     * @stability stable
     */
    get riscLevel(): string;
    /**
     * @stability stable
     */
    set riscLevel(value: string);
    /**
     * @stability stable
     */
    resetRiscLevel(): void;
    /**
     * @stability stable
     */
    get riscLevelInput(): string | undefined;
    private _sessionIdle?;
    /**
     * @stability stable
     */
    get sessionIdle(): number;
    /**
     * @stability stable
     */
    set sessionIdle(value: number);
    /**
     * @stability stable
     */
    resetSessionIdle(): void;
    /**
     * @stability stable
     */
    get sessionIdleInput(): number | undefined;
    private _sessionLifetime?;
    /**
     * @stability stable
     */
    get sessionLifetime(): number;
    /**
     * @stability stable
     */
    set sessionLifetime(value: number);
    /**
     * @stability stable
     */
    resetSessionLifetime(): void;
    /**
     * @stability stable
     */
    get sessionLifetimeInput(): number | undefined;
    private _sessionPersistent?;
    /**
     * @stability stable
     */
    get sessionPersistent(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sessionPersistent(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSessionPersistent(): void;
    /**
     * @stability stable
     */
    get sessionPersistentInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _usersExcluded?;
    /**
     * @stability stable
     */
    get usersExcluded(): string[];
    /**
     * @stability stable
     */
    set usersExcluded(value: string[]);
    /**
     * @stability stable
     */
    resetUsersExcluded(): void;
    /**
     * @stability stable
     */
    get usersExcludedInput(): string[] | undefined;
    private _factorSequence?;
    /**
     * @stability stable
     */
    get factorSequence(): SignonPolicyRuleFactorSequence[];
    /**
     * @stability stable
     */
    set factorSequence(value: SignonPolicyRuleFactorSequence[]);
    /**
     * @stability stable
     */
    resetFactorSequence(): void;
    /**
     * @stability stable
     */
    get factorSequenceInput(): SignonPolicyRuleFactorSequence[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
