import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SocialIdpConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#account_link_action SocialIdp#account_link_action}.
     *
     * @stability stable
     */
    readonly accountLinkAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#account_link_group_include SocialIdp#account_link_group_include}.
     *
     * @stability stable
     */
    readonly accountLinkGroupInclude?: string[];
    /**
     * The Key ID that you obtained from Apple when you created the private key for the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#apple_kid SocialIdp#apple_kid}
     *
     * @stability stable
     */
    readonly appleKid?: string;
    /**
     * The PKCS #8 encoded private key that you created for the client and downloaded from Apple.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#apple_private_key SocialIdp#apple_private_key}
     *
     * @stability stable
     */
    readonly applePrivateKey?: string;
    /**
     * The Team ID associated with your Apple developer account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#apple_team_id SocialIdp#apple_team_id}
     *
     * @stability stable
     */
    readonly appleTeamId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#client_id SocialIdp#client_id}.
     *
     * @stability stable
     */
    readonly clientId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#client_secret SocialIdp#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#deprovisioned_action SocialIdp#deprovisioned_action}.
     *
     * @stability stable
     */
    readonly deprovisionedAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#groups_action SocialIdp#groups_action}.
     *
     * @stability stable
     */
    readonly groupsAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#groups_assignment SocialIdp#groups_assignment}.
     *
     * @stability stable
     */
    readonly groupsAssignment?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#groups_attribute SocialIdp#groups_attribute}.
     *
     * @stability stable
     */
    readonly groupsAttribute?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#groups_filter SocialIdp#groups_filter}.
     *
     * @stability stable
     */
    readonly groupsFilter?: string[];
    /**
     * Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#issuer_mode SocialIdp#issuer_mode}
     *
     * @stability stable
     */
    readonly issuerMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#match_attribute SocialIdp#match_attribute}.
     *
     * @stability stable
     */
    readonly matchAttribute?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#match_type SocialIdp#match_type}.
     *
     * @stability stable
     */
    readonly matchType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#max_clock_skew SocialIdp#max_clock_skew}.
     *
     * @stability stable
     */
    readonly maxClockSkew?: number;
    /**
     * Name of the IdP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#name SocialIdp#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#profile_master SocialIdp#profile_master}.
     *
     * @stability stable
     */
    readonly profileMaster?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#protocol_type SocialIdp#protocol_type}.
     *
     * @stability stable
     */
    readonly protocolType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#provisioning_action SocialIdp#provisioning_action}.
     *
     * @stability stable
     */
    readonly provisioningAction?: string;
    /**
     * algorithm to use to sign requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#request_signature_algorithm SocialIdp#request_signature_algorithm}
     *
     * @stability stable
     */
    readonly requestSignatureAlgorithm?: string;
    /**
     * algorithm to use to sign response.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#request_signature_scope SocialIdp#request_signature_scope}
     *
     * @stability stable
     */
    readonly requestSignatureScope?: string;
    /**
     * algorithm to use to sign requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#response_signature_algorithm SocialIdp#response_signature_algorithm}
     *
     * @stability stable
     */
    readonly responseSignatureAlgorithm?: string;
    /**
     * algorithm to use to sign response.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#response_signature_scope SocialIdp#response_signature_scope}
     *
     * @stability stable
     */
    readonly responseSignatureScope?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#scopes SocialIdp#scopes}.
     *
     * @stability stable
     */
    readonly scopes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#status SocialIdp#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#subject_match_attribute SocialIdp#subject_match_attribute}.
     *
     * @stability stable
     */
    readonly subjectMatchAttribute?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#subject_match_type SocialIdp#subject_match_type}.
     *
     * @stability stable
     */
    readonly subjectMatchType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#suspended_action SocialIdp#suspended_action}.
     *
     * @stability stable
     */
    readonly suspendedAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#type SocialIdp#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html#username_template SocialIdp#username_template}.
     *
     * @stability stable
     */
    readonly usernameTemplate?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html okta_social_idp}.
 *
 * @stability stable
 */
export declare class SocialIdp extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/social_idp.html okta_social_idp} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SocialIdpConfig);
    private _accountLinkAction?;
    /**
     * @stability stable
     */
    get accountLinkAction(): string;
    /**
     * @stability stable
     */
    set accountLinkAction(value: string);
    /**
     * @stability stable
     */
    resetAccountLinkAction(): void;
    /**
     * @stability stable
     */
    get accountLinkActionInput(): string | undefined;
    private _accountLinkGroupInclude?;
    /**
     * @stability stable
     */
    get accountLinkGroupInclude(): string[];
    /**
     * @stability stable
     */
    set accountLinkGroupInclude(value: string[]);
    /**
     * @stability stable
     */
    resetAccountLinkGroupInclude(): void;
    /**
     * @stability stable
     */
    get accountLinkGroupIncludeInput(): string[] | undefined;
    private _appleKid?;
    /**
     * @stability stable
     */
    get appleKid(): string;
    /**
     * @stability stable
     */
    set appleKid(value: string);
    /**
     * @stability stable
     */
    resetAppleKid(): void;
    /**
     * @stability stable
     */
    get appleKidInput(): string | undefined;
    private _applePrivateKey?;
    /**
     * @stability stable
     */
    get applePrivateKey(): string;
    /**
     * @stability stable
     */
    set applePrivateKey(value: string);
    /**
     * @stability stable
     */
    resetApplePrivateKey(): void;
    /**
     * @stability stable
     */
    get applePrivateKeyInput(): string | undefined;
    private _appleTeamId?;
    /**
     * @stability stable
     */
    get appleTeamId(): string;
    /**
     * @stability stable
     */
    set appleTeamId(value: string);
    /**
     * @stability stable
     */
    resetAppleTeamId(): void;
    /**
     * @stability stable
     */
    get appleTeamIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get authorizationBinding(): string;
    /**
     * @stability stable
     */
    get authorizationUrl(): string;
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    resetClientId(): void;
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    resetClientSecret(): void;
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _deprovisionedAction?;
    /**
     * @stability stable
     */
    get deprovisionedAction(): string;
    /**
     * @stability stable
     */
    set deprovisionedAction(value: string);
    /**
     * @stability stable
     */
    resetDeprovisionedAction(): void;
    /**
     * @stability stable
     */
    get deprovisionedActionInput(): string | undefined;
    private _groupsAction?;
    /**
     * @stability stable
     */
    get groupsAction(): string;
    /**
     * @stability stable
     */
    set groupsAction(value: string);
    /**
     * @stability stable
     */
    resetGroupsAction(): void;
    /**
     * @stability stable
     */
    get groupsActionInput(): string | undefined;
    private _groupsAssignment?;
    /**
     * @stability stable
     */
    get groupsAssignment(): string[];
    /**
     * @stability stable
     */
    set groupsAssignment(value: string[]);
    /**
     * @stability stable
     */
    resetGroupsAssignment(): void;
    /**
     * @stability stable
     */
    get groupsAssignmentInput(): string[] | undefined;
    private _groupsAttribute?;
    /**
     * @stability stable
     */
    get groupsAttribute(): string;
    /**
     * @stability stable
     */
    set groupsAttribute(value: string);
    /**
     * @stability stable
     */
    resetGroupsAttribute(): void;
    /**
     * @stability stable
     */
    get groupsAttributeInput(): string | undefined;
    private _groupsFilter?;
    /**
     * @stability stable
     */
    get groupsFilter(): string[];
    /**
     * @stability stable
     */
    set groupsFilter(value: string[]);
    /**
     * @stability stable
     */
    resetGroupsFilter(): void;
    /**
     * @stability stable
     */
    get groupsFilterInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _issuerMode?;
    /**
     * @stability stable
     */
    get issuerMode(): string;
    /**
     * @stability stable
     */
    set issuerMode(value: string);
    /**
     * @stability stable
     */
    resetIssuerMode(): void;
    /**
     * @stability stable
     */
    get issuerModeInput(): string | undefined;
    private _matchAttribute?;
    /**
     * @stability stable
     */
    get matchAttribute(): string;
    /**
     * @stability stable
     */
    set matchAttribute(value: string);
    /**
     * @stability stable
     */
    resetMatchAttribute(): void;
    /**
     * @stability stable
     */
    get matchAttributeInput(): string | undefined;
    private _matchType?;
    /**
     * @stability stable
     */
    get matchType(): string;
    /**
     * @stability stable
     */
    set matchType(value: string);
    /**
     * @stability stable
     */
    resetMatchType(): void;
    /**
     * @stability stable
     */
    get matchTypeInput(): string | undefined;
    private _maxClockSkew?;
    /**
     * @stability stable
     */
    get maxClockSkew(): number;
    /**
     * @stability stable
     */
    set maxClockSkew(value: number);
    /**
     * @stability stable
     */
    resetMaxClockSkew(): void;
    /**
     * @stability stable
     */
    get maxClockSkewInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _profileMaster?;
    /**
     * @stability stable
     */
    get profileMaster(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set profileMaster(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProfileMaster(): void;
    /**
     * @stability stable
     */
    get profileMasterInput(): boolean | cdktf.IResolvable | undefined;
    private _protocolType?;
    /**
     * @stability stable
     */
    get protocolType(): string;
    /**
     * @stability stable
     */
    set protocolType(value: string);
    /**
     * @stability stable
     */
    resetProtocolType(): void;
    /**
     * @stability stable
     */
    get protocolTypeInput(): string | undefined;
    private _provisioningAction?;
    /**
     * @stability stable
     */
    get provisioningAction(): string;
    /**
     * @stability stable
     */
    set provisioningAction(value: string);
    /**
     * @stability stable
     */
    resetProvisioningAction(): void;
    /**
     * @stability stable
     */
    get provisioningActionInput(): string | undefined;
    private _requestSignatureAlgorithm?;
    /**
     * @stability stable
     */
    get requestSignatureAlgorithm(): string;
    /**
     * @stability stable
     */
    set requestSignatureAlgorithm(value: string);
    /**
     * @stability stable
     */
    resetRequestSignatureAlgorithm(): void;
    /**
     * @stability stable
     */
    get requestSignatureAlgorithmInput(): string | undefined;
    private _requestSignatureScope?;
    /**
     * @stability stable
     */
    get requestSignatureScope(): string;
    /**
     * @stability stable
     */
    set requestSignatureScope(value: string);
    /**
     * @stability stable
     */
    resetRequestSignatureScope(): void;
    /**
     * @stability stable
     */
    get requestSignatureScopeInput(): string | undefined;
    private _responseSignatureAlgorithm?;
    /**
     * @stability stable
     */
    get responseSignatureAlgorithm(): string;
    /**
     * @stability stable
     */
    set responseSignatureAlgorithm(value: string);
    /**
     * @stability stable
     */
    resetResponseSignatureAlgorithm(): void;
    /**
     * @stability stable
     */
    get responseSignatureAlgorithmInput(): string | undefined;
    private _responseSignatureScope?;
    /**
     * @stability stable
     */
    get responseSignatureScope(): string;
    /**
     * @stability stable
     */
    set responseSignatureScope(value: string);
    /**
     * @stability stable
     */
    resetResponseSignatureScope(): void;
    /**
     * @stability stable
     */
    get responseSignatureScopeInput(): string | undefined;
    private _scopes?;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    set scopes(value: string[]);
    /**
     * @stability stable
     */
    get scopesInput(): string[] | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _subjectMatchAttribute?;
    /**
     * @stability stable
     */
    get subjectMatchAttribute(): string;
    /**
     * @stability stable
     */
    set subjectMatchAttribute(value: string);
    /**
     * @stability stable
     */
    resetSubjectMatchAttribute(): void;
    /**
     * @stability stable
     */
    get subjectMatchAttributeInput(): string | undefined;
    private _subjectMatchType?;
    /**
     * @stability stable
     */
    get subjectMatchType(): string;
    /**
     * @stability stable
     */
    set subjectMatchType(value: string);
    /**
     * @stability stable
     */
    resetSubjectMatchType(): void;
    /**
     * @stability stable
     */
    get subjectMatchTypeInput(): string | undefined;
    private _suspendedAction?;
    /**
     * @stability stable
     */
    get suspendedAction(): string;
    /**
     * @stability stable
     */
    set suspendedAction(value: string);
    /**
     * @stability stable
     */
    resetSuspendedAction(): void;
    /**
     * @stability stable
     */
    get suspendedActionInput(): string | undefined;
    /**
     * @stability stable
     */
    get tokenBinding(): string;
    /**
     * @stability stable
     */
    get tokenUrl(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _usernameTemplate?;
    /**
     * @stability stable
     */
    get usernameTemplate(): string;
    /**
     * @stability stable
     */
    set usernameTemplate(value: string);
    /**
     * @stability stable
     */
    resetUsernameTemplate(): void;
    /**
     * @stability stable
     */
    get usernameTemplateInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
