import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TemplateEmailConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_email.html#default_language TemplateEmail#default_language}.
     *
     * @stability stable
     */
    readonly defaultLanguage?: string;
    /**
     * Email template type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_email.html#type TemplateEmail#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * translations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_email.html#translations TemplateEmail#translations}
     *
     * @stability stable
     */
    readonly translations: TemplateEmailTranslations[];
}
/**
 * @stability stable
 */
export interface TemplateEmailTranslations {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_email.html#language TemplateEmail#language}.
     *
     * @stability stable
     */
    readonly language: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_email.html#subject TemplateEmail#subject}.
     *
     * @stability stable
     */
    readonly subject: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_email.html#template TemplateEmail#template}.
     *
     * @stability stable
     */
    readonly template: string;
}
export declare function templateEmailTranslationsToTerraform(struct?: TemplateEmailTranslations): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/template_email.html okta_template_email}.
 *
 * @stability stable
 */
export declare class TemplateEmail extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/template_email.html okta_template_email} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TemplateEmailConfig);
    private _defaultLanguage?;
    /**
     * @stability stable
     */
    get defaultLanguage(): string;
    /**
     * @stability stable
     */
    set defaultLanguage(value: string);
    /**
     * @stability stable
     */
    resetDefaultLanguage(): void;
    /**
     * @stability stable
     */
    get defaultLanguageInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _translations?;
    /**
     * @stability stable
     */
    get translations(): TemplateEmailTranslations[];
    /**
     * @stability stable
     */
    set translations(value: TemplateEmailTranslations[]);
    /**
     * @stability stable
     */
    get translationsInput(): TemplateEmailTranslations[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
