import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TemplateSmsConfig extends cdktf.TerraformMetaArguments {
    /**
     * SMS default template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_sms.html#template TemplateSms#template}
     *
     * @stability stable
     */
    readonly template: string;
    /**
     * SMS template type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_sms.html#type TemplateSms#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * translations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_sms.html#translations TemplateSms#translations}
     *
     * @stability stable
     */
    readonly translations?: TemplateSmsTranslations[];
}
/**
 * @stability stable
 */
export interface TemplateSmsTranslations {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_sms.html#language TemplateSms#language}.
     *
     * @stability stable
     */
    readonly language: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/template_sms.html#template TemplateSms#template}.
     *
     * @stability stable
     */
    readonly template: string;
}
export declare function templateSmsTranslationsToTerraform(struct?: TemplateSmsTranslations): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/template_sms.html okta_template_sms}.
 *
 * @stability stable
 */
export declare class TemplateSms extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/template_sms.html okta_template_sms} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TemplateSmsConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _template?;
    /**
     * @stability stable
     */
    get template(): string;
    /**
     * @stability stable
     */
    set template(value: string);
    /**
     * @stability stable
     */
    get templateInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _translations?;
    /**
     * @stability stable
     */
    get translations(): TemplateSmsTranslations[];
    /**
     * @stability stable
     */
    set translations(value: TemplateSmsTranslations[]);
    /**
     * @stability stable
     */
    resetTranslations(): void;
    /**
     * @stability stable
     */
    get translationsInput(): TemplateSmsTranslations[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
