import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ThreatInsightSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies how Okta responds to authentication requests from suspicious IPs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/threat_insight_settings.html#action ThreatInsightSettings#action}
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * List of Network Zone IDs to exclude to be not logged or blocked by Okta ThreatInsight and proceed to Sign On rules evaluation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/threat_insight_settings.html#network_excludes ThreatInsightSettings#network_excludes}
     *
     * @stability stable
     */
    readonly networkExcludes?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/threat_insight_settings.html okta_threat_insight_settings}.
 *
 * @stability stable
 */
export declare class ThreatInsightSettings extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/threat_insight_settings.html okta_threat_insight_settings} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ThreatInsightSettingsConfig);
    private _action?;
    /**
     * @stability stable
     */
    get action(): string;
    /**
     * @stability stable
     */
    set action(value: string);
    /**
     * @stability stable
     */
    get actionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _networkExcludes?;
    /**
     * @stability stable
     */
    get networkExcludes(): string[];
    /**
     * @stability stable
     */
    set networkExcludes(value: string[]);
    /**
     * @stability stable
     */
    resetNetworkExcludes(): void;
    /**
     * @stability stable
     */
    get networkExcludesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
