import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TrustedOriginConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether the Trusted Origin is active or not - can only be issued post-creation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/trusted_origin.html#active TrustedOrigin#active}
     *
     * @stability stable
     */
    readonly active?: boolean | cdktf.IResolvable;
    /**
     * Unique name for this trusted origin.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/trusted_origin.html#name TrustedOrigin#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Unique origin URL for this trusted origin.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/trusted_origin.html#origin TrustedOrigin#origin}
     *
     * @stability stable
     */
    readonly origin: string;
    /**
     * Scopes of the Trusted Origin - can either be CORS or REDIRECT only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/trusted_origin.html#scopes TrustedOrigin#scopes}
     *
     * @stability stable
     */
    readonly scopes: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/trusted_origin.html okta_trusted_origin}.
 *
 * @stability stable
 */
export declare class TrustedOrigin extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/trusted_origin.html okta_trusted_origin} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TrustedOriginConfig);
    private _active?;
    /**
     * @stability stable
     */
    get active(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set active(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetActive(): void;
    /**
     * @stability stable
     */
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _origin?;
    /**
     * @stability stable
     */
    get origin(): string;
    /**
     * @stability stable
     */
    set origin(value: string);
    /**
     * @stability stable
     */
    get originInput(): string | undefined;
    private _scopes?;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    set scopes(value: string[]);
    /**
     * @stability stable
     */
    get scopesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
