import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface UserAdminRolesConfig extends cdktf.TerraformMetaArguments {
    /**
     * User Okta admin roles - ie. ['APP_ADMIN', 'USER_ADMIN'].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_admin_roles.html#admin_roles UserAdminRoles#admin_roles}
     *
     * @stability stable
     */
    readonly adminRoles: string[];
    /**
     * When this setting is enabled, the admins won't receive any of the default Okta administrator emails.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_admin_roles.html#disable_notifications UserAdminRoles#disable_notifications}
     *
     * @stability stable
     */
    readonly disableNotifications?: boolean | cdktf.IResolvable;
    /**
     * ID of a Okta User.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/user_admin_roles.html#user_id UserAdminRoles#user_id}
     *
     * @stability stable
     */
    readonly userId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/okta/r/user_admin_roles.html okta_user_admin_roles}.
 *
 * @stability stable
 */
export declare class UserAdminRoles extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/okta/r/user_admin_roles.html okta_user_admin_roles} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: UserAdminRolesConfig);
    private _adminRoles?;
    /**
     * @stability stable
     */
    get adminRoles(): string[];
    /**
     * @stability stable
     */
    set adminRoles(value: string[]);
    /**
     * @stability stable
     */
    get adminRolesInput(): string[] | undefined;
    private _disableNotifications?;
    /**
     * @stability stable
     */
    get disableNotifications(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableNotifications(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableNotifications(): void;
    /**
     * @stability stable
     */
    get disableNotificationsInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string;
    /**
     * @stability stable
     */
    set userId(value: string);
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
